/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.inventory;

import com.sap.cloud.lm.sl.hcp.client.inventory.json.DeployedMta;
import com.sap.cloud.lm.sl.hcp.client.inventory.json.DeployedMtaComponent;
import com.sap.cloud.lm.sl.hcp.client.inventory.json.DeployedMtaModule;
import com.sap.cloud.lm.sl.hcp.client.inventory.json.DeployedMtaParameter;
import com.sap.cloud.lm.sl.hcp.client.inventory.json.DeployedRequiredDependency;
import com.sap.cloud.lm.sl.hcp.client.utils.OutputHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InventoryOutputHelper {
    private static final Logger LOGGER = Logger.getLogger(InventoryOutputHelper.class);
    private static final int DEFAULT_PADDING_KEY = 12;
    private static final int ADDITIONAL_PADDING_KEY = 17;
    private static final int DEFAULT_HEADER_LENGTH = 60;
    private static final String DEFAULT_HEADER_SYMBOL = "-";
    private static final String MTA_PARAMETER_TITLE = "title";
    private static final String MTA_PARAMETER_DESCRIPTION = "description";

    public static void dumpAndLog(List<DeployedMta> deployedMtas, String subaccount, boolean listAvailableForSubscription) {
        int additionalPadding = listAvailableForSubscription ? 17 : 0;
        for (DeployedMta deployedMta : deployedMtas) {
            InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatHeader(), 0);
            InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("ID", deployedMta.getId(), additionalPadding), 0);
            if (listAvailableForSubscription) {
                InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Extension ID", InventoryOutputHelper.getExtensionId(deployedMta), additionalPadding), 0);
            }
            InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Version", InventoryOutputHelper.getMtaVersion(deployedMta), additionalPadding), 0);
            InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Subaccount", subaccount, additionalPadding), 0);
            InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Mode", InventoryOutputHelper.getMtaImportMode(deployedMta, subaccount), additionalPadding), 0);
            if (listAvailableForSubscription) {
                InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Provider subaccount", deployedMta.getAccount(), additionalPadding), 0);
                InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Provider Global Account GUID", deployedMta.getGlobalAccountGuid(), additionalPadding), 0);
            }
            InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Title", InventoryOutputHelper.getMtaTitle(deployedMta), additionalPadding), 0);
            InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Description", InventoryOutputHelper.getMtaDescription(deployedMta), additionalPadding), 0);
        }
    }

    public static void dumpAndLog(DeployedMta deployedMta, String subaccount) {
        InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("ID", deployedMta.getId(), 0), 0);
        InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Version", InventoryOutputHelper.getMtaVersion(deployedMta), 0), 0);
        InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Subaccount", deployedMta.getAccount(), 0), 0);
        InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Mode", InventoryOutputHelper.getMtaImportMode(deployedMta, subaccount), 0), 0);
        if (deployedMta.getParameters() != null) {
            InventoryOutputHelper.dumpAndLogMtaParameters(deployedMta.getParameters());
        }
        if (deployedMta.getModules() != null) {
            InventoryOutputHelper.dumpAndLogMtaComponents(deployedMta.getModules());
        }
    }

    private static void dumpAndLogMtaParameters(Map<String, DeployedMtaParameter> parameters) {
        InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Parameters", "", 0), 0);
        for (Map.Entry<String, DeployedMtaParameter> entry : parameters.entrySet()) {
            InventoryOutputHelper.dumpAndLog(String.format("%s: %s", entry.getKey(), InventoryOutputHelper.cutMessage(entry.getValue().getValue())), 1);
        }
    }

    private static void dumpAndLogMtaComponents(List<DeployedMtaModule> modules) {
        InventoryOutputHelper.dumpAndLog(InventoryOutputHelper.formatMessage("Components", "", 0), 0);
        for (DeployedMtaModule module : modules) {
            for (DeployedMtaComponent moduleComponent : module.getComponents()) {
                if (moduleComponent.getParent() != null) continue;
                String description = InventoryOutputHelper.getUserFriendlyComponentType(moduleComponent.getType(), moduleComponent.getParent());
                InventoryOutputHelper.dumpAndLog(String.format("%s: %s", description, moduleComponent.getName()), 1);
                InventoryOutputHelper.dumpAndLogMtaChildComponents(moduleComponent, module.getComponents());
                if (module.getRequiredDependencies() == null) continue;
                InventoryOutputHelper.dumpAndLogMtaRequiredDependencies(moduleComponent, module.getRequiredDependencies());
            }
        }
    }

    private static void dumpAndLogMtaChildComponents(DeployedMtaComponent parentComponent, List<DeployedMtaComponent> moduleComponents) {
        for (DeployedMtaComponent moduleComponent : moduleComponents) {
            InventoryOutputHelper.dumpAndLogMtaChildComponent(moduleComponent, parentComponent);
        }
    }

    private static void dumpAndLogMtaRequiredDependencies(DeployedMtaComponent moduleComponent, List<DeployedRequiredDependency> dependencies) {
        for (DeployedRequiredDependency dependency : dependencies) {
            InventoryOutputHelper.dumpAndLogMtaChildComponents(moduleComponent, dependency.getComponents());
        }
    }

    private static void dumpAndLogMtaChildComponent(DeployedMtaComponent component, DeployedMtaComponent parentComponent) {
        if (component.getParent() != null) {
            boolean hasSameName = component.getParent().getName().equals(parentComponent.getName());
            boolean hasSameType = component.getParent().getType().equals(parentComponent.getType());
            if (hasSameName && hasSameType) {
                String description = InventoryOutputHelper.getUserFriendlyComponentType(component.getType(), component.getParent());
                InventoryOutputHelper.dumpAndLog(String.format("%s: %s", description, component.getName()), 2);
            }
        }
    }

    private static String getUserFriendlyComponentType(String type, DeployedMtaComponent parentComponent) {
        if (type == null) {
            return "N/A";
        }
        if ("JAVA_APP".toLowerCase().equals(type.toLowerCase())) {
            return "Java Application";
        }
        if ("HTML5_APP".toLowerCase().equals(type.toLowerCase())) {
            return "HTML5 Application";
        }
        if ("DESTINATION".toLowerCase().equals(type.toLowerCase())) {
            if (parentComponent != null && parentComponent.getType().toLowerCase().equals("JAVA_APP".toLowerCase())) {
                return "Application Destination";
            }
            if (parentComponent != null && parentComponent.getType().toLowerCase().equals("JAVA_APP_SUBSCRIPTION".toLowerCase())) {
                return "Application Subscription Destination";
            }
            if (parentComponent == null) {
                return "Subaccount Destination";
            }
            return "DESTINATION";
        }
        if ("DB_BINDING".toLowerCase().equals(type.toLowerCase())) {
            return "Data Source Binding";
        }
        if ("SFSF_CONNECTION".toLowerCase().equals(type.toLowerCase())) {
            return "SAP SuccessFactors Connection";
        }
        if ("SFSF_ROLE".toLowerCase().equals(type.toLowerCase())) {
            return "SAP SuccessFactors Role";
        }
        if ("SFSF_TILE".toLowerCase().equals(type.toLowerCase())) {
            return "SAP SuccessFactors Homepage Tile";
        }
        if ("SFSF_APPLICATION_ACCESS".toLowerCase().equals(type.toLowerCase())) {
            return "SAP SuccessFactors Application Access";
        }
        if ("SFSF_ROLE_PROVIDER".toLowerCase().equals(type.toLowerCase())) {
            return "SAP SuccessFactors Role Provider";
        }
        if ("ROLE".toLowerCase().equals(type.toLowerCase())) {
            return "Role";
        }
        if ("JAVA_APP_SUBSCRIPTION".toLowerCase().equals(type.toLowerCase())) {
            return "Java Application Subscription";
        }
        if ("HTML5_APP_SUBSCRIPTION".toLowerCase().equals(type.toLowerCase())) {
            return "HTML5 Application Subscription";
        }
        if ("ODP_SERVICE".toLowerCase().equals(type.toLowerCase())) {
            return "OData Service";
        }
        if ("GWAAS_SERVICE".toLowerCase().equals(type.toLowerCase())) {
            return "Gateway as a Service";
        }
        if ("FIORI_CONTENT".toLowerCase().equals(type.toLowerCase())) {
            return "Fiori Content";
        }
        if ("GROUP".toLowerCase().equals(type.toLowerCase())) {
            return "Group";
        }
        if ("ROLE_GROUPS_ASSIGNMENT".toLowerCase().equals(type.toLowerCase())) {
            return "Role Assignment";
        }
        if ("FIORI_APP".toLowerCase().equals(type.toLowerCase())) {
            return "Fiori HTML5 Application";
        }
        if ("FIORI_ROLE".toLowerCase().equals(type.toLowerCase())) {
            return "HTML5 Role";
        }
        if ("HCI_CONTENT".toLowerCase().equals(type.toLowerCase())) {
            return "Integration Content";
        }
        if ("GWAAS_DESTINATION".toLowerCase().equals(type.toLowerCase())) {
            return "OData Provisioning Destination";
        }
        if ("PORTAL_DESTINATION".toLowerCase().equals(type.toLowerCase())) {
            return "Cloud Portal Destination";
        }
        return type;
    }

    private static void dumpAndLog(String message, int indentation) {
        OutputHelper.printLnInTree(message, indentation);
        LOGGER.info((Object)message);
    }

    private static String formatMessage(String key, String value, int additionalPadding) {
        String left = InventoryOutputHelper.formatListMessage(key, additionalPadding);
        return String.format("%s: %s", left, value);
    }

    private static String formatListMessage(String key, int additionalPadding) {
        return InventoryOutputHelper.addPadding(key, 12 + additionalPadding, " ".toCharArray()[0]);
    }

    private static String formatHeader() {
        return new String(new char[60]).replace("\u0000", DEFAULT_HEADER_SYMBOL);
    }

    private static String getMtaVersion(DeployedMta deployedMta) {
        return deployedMta.getVersion() != null && !deployedMta.getVersion().isEmpty() ? deployedMta.getVersion() : "N/A";
    }

    private static String getExtensionId(DeployedMta deployedMta) {
        return deployedMta.getIdForExtending() != null && !deployedMta.getIdForExtending().isEmpty() ? deployedMta.getIdForExtending() : "N/A";
    }

    private static String getMtaImportMode(DeployedMta deployedMta, String subaccount) {
        String mode;
        String string = mode = deployedMta.getImportMode() != null && !deployedMta.getImportMode().isEmpty() ? deployedMta.getImportMode() : "N/A";
        if ("IMPORT".toLowerCase().equals(mode.toLowerCase())) {
            return "Standard";
        }
        if ("CONSUMERIMPORT".toLowerCase().equals(mode.toLowerCase())) {
            return "Subscribed";
        }
        if ("PROVIDERIMPORT".toLowerCase().equals(mode.toLowerCase())) {
            if (!subaccount.equals(deployedMta.getAccount())) {
                return "Available for subscription";
            }
            return "Provided";
        }
        if ("PROVIDERDECLARE".toLowerCase().equals(mode.toLowerCase())) {
            if (!subaccount.equals(deployedMta.getAccount())) {
                return "Available for subscription";
            }
            return "Declared";
        }
        return mode.toLowerCase();
    }

    private static String getMtaTitle(DeployedMta deployedMta) {
        String title = "N/A";
        if (deployedMta.getParameters() != null && deployedMta.getParameters().containsKey(MTA_PARAMETER_TITLE)) {
            title = deployedMta.getParameters().get(MTA_PARAMETER_TITLE).getValue();
        }
        return InventoryOutputHelper.cutMessage(title);
    }

    private static String getMtaDescription(DeployedMta deployedMta) {
        String description = "N/A";
        if (deployedMta.getParameters() != null && deployedMta.getParameters().containsKey(MTA_PARAMETER_DESCRIPTION)) {
            description = deployedMta.getParameters().get(MTA_PARAMETER_DESCRIPTION).getValue();
        }
        return InventoryOutputHelper.cutMessage(description);
    }

    private static String cutMessage(String message) {
        if (message.length() > 60) {
            message = message.substring(0, 60);
            message = message.substring(0, message.length() - 3);
            message = message + "...";
        }
        return message;
    }

    private static String addPadding(String message, int indentation, char c) {
        int length = Math.max(message.length(), indentation);
        StringBuilder sb = new StringBuilder(message);
        char[] ch = new char[length -= message.length()];
        Arrays.fill(ch, c);
        sb.insert(message.length(), ch);
        return sb.toString();
    }
}

