/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.utils;

import com.beust.jcommander.ParameterException;
import com.sap.cloud.lm.sl.hcp.client.utils.OutputHelper;
import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.io.FilenameUtils;

public class CheckHelper {
    public static boolean checkArgSpecified(String shortName, String longName, String value, boolean skipWarning) {
        if (value == null || value.trim().isEmpty()) {
            if (!skipWarning) {
                if (shortName != null) {
                    OutputHelper.dumpErrorMessage((String)MessageFormat.format("The following option is required: {0}", shortName + ", " + longName));
                } else {
                    OutputHelper.dumpErrorMessage((String)MessageFormat.format("The following option is required: {0}", longName));
                }
            }
            return false;
        }
        return true;
    }

    public static boolean fileExist(String path) {
        File f = new File(path);
        return f.exists() && !f.isDirectory();
    }

    public static boolean isFolder(String path) {
        File f = new File(path);
        return f.isDirectory();
    }

    public static String[] getFileNames(String dir, String fileExtension) {
        File[] listOfFiles;
        String fileNames = "";
        File folder = new File(dir);
        for (File file : listOfFiles = folder.listFiles()) {
            if (!file.isFile() || !FilenameUtils.getExtension((String)file.getAbsolutePath()).equalsIgnoreCase(fileExtension)) continue;
            fileNames = fileNames + file.getAbsolutePath() + ",";
        }
        if (fileNames.length() > 0) {
            fileNames = fileNames.substring(0, fileNames.length() - 1);
        }
        return fileNames.split(",");
    }

    public static void validateFileLocations(String value, String paramShort, String param, String fileExtension) {
        if (value == null || value.trim().equalsIgnoreCase("")) {
            throw new ParameterException(MessageFormat.format("Parameter ''{0}'' ''{1}'' does not accept empty value", paramShort, param));
        }
        String[] fileNames = value.split(",");
        if (fileNames.length == 1 && CheckHelper.isFolder(fileNames[0].trim())) {
            if ((fileNames = CheckHelper.getFileNames(fileNames[0].trim(), fileExtension)).length == 0 || fileNames.length == 1 && fileNames[0].trim().equals("")) {
                throw new ParameterException(MessageFormat.format("Path ''{0}'' does not contain any valid files with extension ''{1}''", value, fileExtension));
            }
        } else {
            for (int i = 0; i < fileNames.length; ++i) {
                if (CheckHelper.fileExist(fileNames[i].trim())) continue;
                throw new ParameterException(MessageFormat.format("Parameter ''{0}'' ''{1}'' value contains file path ''{2}'' which does not exist", paramShort, param, fileNames[i].trim()));
            }
        }
    }
}

