/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.utils;

import com.sap.cloud.lm.sl.hcp.client.core.json.DeployModuleState;
import com.sap.cloud.lm.sl.hcp.client.core.json.DeployMtaProgress;
import com.sap.cloud.lm.sl.hcp.client.core.json.DeployStateObject;
import com.sap.cloud.lm.sl.hcp.client.utils.Constants;
import com.sap.cloud.lm.sl.hcp.client.utils.OutputHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OperationOutputHelper {
    public abstract String getOperationStartedMessage(String var1);

    public abstract String getOperationFinishedMessage(String var1);

    public abstract String getOperationFailedMessage(String var1);

    protected abstract String getMtaStartedMessage(DeployMtaProgress var1);

    protected abstract String getMtaFinishedMessage(DeployMtaProgress var1);

    protected abstract String getMtaFailedMessage(DeployMtaProgress var1);

    protected abstract String getModuleStartedMessage(DeployModuleState var1);

    protected abstract String getModuleFinishedMessage(DeployModuleState var1);

    protected abstract String getModuleFailedMessage(DeployModuleState var1);

    public void printIncrementalDeployStatus(DeployStateObject newStateObj, DeployStateObject currentStateObj) {
        Map<String, DeployMtaProgress> newState = newStateObj.toMtaMap();
        if (currentStateObj == null) {
            currentStateObj = new DeployStateObject();
        }
        Map<String, DeployMtaProgress> currentState = currentStateObj.toMtaMap();
        for (Map.Entry<String, DeployMtaProgress> mta : newState.entrySet()) {
            if (currentState.get(mta.getKey()) == null) continue;
            this.printMtaStateUpdate(currentState.get(mta.getKey()), mta.getValue());
        }
        for (Map.Entry<String, DeployMtaProgress> mta : newState.entrySet()) {
            if (currentState.get(mta.getKey()) != null) continue;
            this.printMtaStateUpdate(null, mta.getValue());
        }
    }

    private void printMtaStateUpdate(DeployMtaProgress oldMtaProgress, DeployMtaProgress newMtaProgress) {
        ArrayList<String> updateModuleNames = new ArrayList<String>();
        HashMap<String, DeployModuleState[]> updates = new HashMap<String, DeployModuleState[]>();
        ArrayList<String> mtaFailInfo = new ArrayList<String>();
        Map<String, DeployModuleState> newModules = newMtaProgress.toModuleMap();
        Map<String, DeployModuleState> oldModules = null;
        if (oldMtaProgress == null) {
            OutputHelper.printMessageWithDate(this.getMtaStartedMessage(newMtaProgress));
            oldModules = Collections.emptyMap();
        }
        oldModules = oldModules == null ? oldMtaProgress.toModuleMap() : oldModules;
        this.checkUpdate(newMtaProgress, updates, mtaFailInfo, oldMtaProgress, newModules, oldModules);
        for (DeployModuleState module : newMtaProgress.getModules()) {
            if (!updates.containsKey(module.getName())) continue;
            updateModuleNames.add(module.getName());
        }
        for (String moduleName : updateModuleNames) {
            DeployModuleState[] statusChange = (DeployModuleState[])updates.get(moduleName);
            this.printModuleStateUpdate(statusChange);
        }
        for (String mtaInfo : mtaFailInfo) {
            OutputHelper.printMessageWithDate(mtaInfo, true);
        }
        if ((updateModuleNames.size() > 0 || mtaFailInfo.size() > 0) && this.checkMtaFinished(newMtaProgress)) {
            OutputHelper.printMessageWithDate(this.getMtaFinishedMessage(newMtaProgress));
        }
    }

    private void checkUpdate(DeployMtaProgress newMtaProgress, Map<String, DeployModuleState[]> updates, List<String> mtaFailInfo, DeployMtaProgress oldMtasObj, Map<String, DeployModuleState> newModules, Map<String, DeployModuleState> oldModules) {
        if (newMtaProgress.getError() != null && (oldMtasObj == null || oldMtasObj.getError() == null)) {
            mtaFailInfo.add(this.getMtaFailedMessage(newMtaProgress));
        }
        for (Map.Entry<String, DeployModuleState> module : newModules.entrySet()) {
            if (oldModules.get(module.getKey()) == null) {
                updates.put(module.getKey(), new DeployModuleState[]{null, module.getValue()});
                continue;
            }
            if (oldModules.get(module.getKey()).getState().equalsIgnoreCase(module.getValue().getState())) continue;
            updates.put(module.getKey(), new DeployModuleState[]{oldModules.get(module.getKey()), module.getValue()});
        }
    }

    private boolean checkMtaFinished(DeployMtaProgress newState) {
        if (newState.toModuleMap().size() < newState.getModules().size()) {
            return false;
        }
        for (DeployModuleState module : newState.getModules()) {
            if (module.getState().equalsIgnoreCase(Constants.ModuleImportState.DONE.toString()) || module.getState().equalsIgnoreCase(Constants.ModuleImportState.FAILED.toString())) continue;
            return false;
        }
        return true;
    }

    private void printModuleStateUpdate(DeployModuleState[] statusChange) {
        if (statusChange != null && statusChange.length == 2) {
            if (statusChange[0] == null) {
                OutputHelper.printMessageWithDate(this.getModuleStartedMessage(statusChange[1]));
                if (statusChange[1].getState().equalsIgnoreCase(Constants.ModuleImportState.DONE.toString())) {
                    OutputHelper.printMessageWithDate(this.getModuleFinishedMessage(statusChange[1]));
                } else if (statusChange[1].getState().equalsIgnoreCase(Constants.ModuleImportState.FAILED.toString())) {
                    OutputHelper.printMessageWithDate(this.getModuleFailedMessage(statusChange[1]));
                }
            } else if (statusChange[1].getState().equalsIgnoreCase(Constants.ModuleImportState.DONE.toString())) {
                if (statusChange[0].getState().equalsIgnoreCase(Constants.ModuleImportState.INITIAL.toString())) {
                    OutputHelper.printMessageWithDate(this.getModuleStartedMessage(statusChange[1]));
                }
                OutputHelper.printMessageWithDate(this.getModuleFinishedMessage(statusChange[1]));
            } else if (statusChange[1].getState().equalsIgnoreCase(Constants.ModuleImportState.FAILED.toString())) {
                OutputHelper.printMessageWithDate(this.getModuleFailedMessage(statusChange[1]));
            }
        }
    }
}

