/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.utils;

import com.sap.cloud.lm.sl.hcp.client.core.json.DeployModuleState;
import com.sap.cloud.lm.sl.hcp.client.core.json.DeployMtaProgress;
import com.sap.cloud.lm.sl.hcp.client.core.json.DeployStateObject;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class OutputHelper
extends DumpHelper {
    private static DateFormat daytimeFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
    public static DateFormat datetimeFormat = new SimpleDateFormat("dd-MMM-yy HH:mm:ss", Locale.US);
    private static final String timeTextSpace = " ";
    private static final String errorPrefix = "(!) ERROR: ";

    private static void dumpErrorMessageSameLine(String message, String severity) {
        if (severity.equals("(!) ERROR")) {
            System.err.println(message);
        } else {
            System.out.print(message);
        }
    }

    public static void printMessageWithDate(String msg, boolean isError) {
        String timestamp = OutputHelper.currentTime();
        OutputHelper.printMessageWithDate(timestamp, msg, isError);
    }

    public static void printMessageWithDate(String msg) {
        OutputHelper.printMessageWithDate(msg, false);
    }

    public static void printMessageWithDate(String timestamp, String msg, boolean isError) {
        if (isError) {
            msg = errorPrefix + msg;
        }
        System.out.println(timestamp + timeTextSpace + msg);
    }

    public static String currentTime() {
        Date date = new Date();
        return daytimeFormat.format(date);
    }

    public static String dateTime(String dateTime) {
        return datetimeFormat.format(new Date(Long.valueOf(dateTime)));
    }

    private static void printLnInTree(String msg, int level, boolean isError) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
        if (isError) {
            OutputHelper.dumpErrorMessageSameLine(msg + LINE_SEPARATOR, "Warning");
        } else {
            System.out.print(msg + LINE_SEPARATOR);
        }
    }

    public static void printLnInTree(String msg, int level) {
        OutputHelper.printLnInTree(msg, level, false);
    }

    public static void printDeployStatus(DeployStateObject stateObj) {
        OutputHelper.printLnInTree("Operation ID : " + stateObj.getId(), 0);
        OutputHelper.printLnInTree("state   : " + stateObj.getState(), 1);
        OutputHelper.printLnInTree("type    : " + stateObj.getType(), 1);
        String mode = stateObj.getMode();
        if (mode != null) {
            OutputHelper.printLnInTree("mode    : " + OutputHelper.getModeText(mode), 1);
        }
        OutputHelper.printLnInTree("start   : " + OutputHelper.dateTime(stateObj.getStartTime()), 1);
        if (stateObj.getEndTime() != null) {
            OutputHelper.printLnInTree("end     : " + OutputHelper.dateTime(stateObj.getEndTime()), 1);
        }
        List<DeployMtaProgress> archives = stateObj.getProgress();
        for (DeployMtaProgress archive : archives) {
            OutputHelper.printLnInTree("archive : " + archive.getFileName(), 1);
            List<DeployModuleState> modules = archive.getModules();
            for (DeployModuleState module : modules) {
                OutputHelper.printLnInTree("module : " + module.getName(), 2);
                String alignSpace = "";
                if (module.getError() != null) {
                    alignSpace = timeTextSpace;
                }
                OutputHelper.printLnInTree("type" + alignSpace + "  : " + module.getType(), 3);
                OutputHelper.printLnInTree("state" + alignSpace + " : " + module.getState(), 3);
                if (module.getError() == null) continue;
                OutputHelper.printLnInTree("error  :  " + module.getError().getErrorCode() + " with id " + module.getError().getUuid(), 3, true);
                OutputHelper.printLnInTree("detail : " + module.getError().getInfo(), 3, true);
            }
            if (archive.getError() == null) continue;
            OutputHelper.printLnInTree("error   :  " + archive.getError().getErrorCode() + " with id " + archive.getError().getUuid(), 2, true);
            OutputHelper.printLnInTree("detail  : " + archive.getError().getInfo(), 2, true);
        }
    }

    private static String getModeText(String mode) {
        if (mode.equals("consumerImport")) {
            return "subscription";
        }
        return mode;
    }

    public static void printDeployStatus(List<DeployStateObject> stateObjs) {
        if (stateObjs == null || stateObjs.size() == 0) {
            OutputHelper.dump((String)"No MTA operation is found");
            return;
        }
        OutputHelper.dump((String)MessageFormat.format("{0} MTA operation(s) found", stateObjs.size()));
        for (DeployStateObject stateObj : stateObjs) {
            OutputHelper.printDeployStatus(stateObj);
        }
    }
}

