/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.utils;

import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class UrlBuilder {
    public static String getSlServiceDestinationUrl(String hostStr, String path, Logger logger) throws FrontendException {
        URL hostUrl = UrlBuilder.getHostUrl(hostStr, logger);
        String host = hostUrl.getHost();
        if (!host.startsWith("slservice")) {
            host = String.format("%s.%s", "slservice", host);
            logger.log((Priority)Level.INFO, (Object)MessageFormat.format("Appended SAP CP SL Service base domain to the host ULR ''{0}''", host));
        }
        String basicUrl = String.format("%s://%s/%s", hostUrl.getProtocol(), host, path);
        logger.log((Priority)Level.DEBUG, (Object)MessageFormat.format("Destination URL is calculated to be ''{0}''", basicUrl));
        return basicUrl;
    }

    private static URL getHostUrl(String hostUrl, Logger logger) {
        URL hostURL;
        try {
            hostURL = new URL(hostUrl);
        }
        catch (MalformedURLException e) {
            logger.log((Priority)Level.ERROR, (Object)MessageFormat.format("Host name {0} is invalid", hostUrl));
            throw new FrontendException((Exception)e);
        }
        return hostURL;
    }
}

