/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.tomcat.log.corrid;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.cloud.runtime.tomcat.log.corrid.internal.RequestProcessorChain;
import com.sap.cloud.runtime.tomcat.log.corrid.internal.RequestProcessorChainInterceptor;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public final class CorrelationIdValve
extends ValveBase
implements RequestProcessorChain {
    private static final String IMPL_CORR_ID_INTERCEPTOR = "com.sap.cloud.runtime.tomcat.log.corrid.impl.CorrelationIdInterceptor";
    private RequestProcessorChainInterceptor requestProcessorChainInterceptor;

    public CorrelationIdValve() {
        super(true);
    }

    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.loadImplementation();
    }

    private void loadImplementation() throws LifecycleException {
        ClassLoader implClassLoader = ClassloadingBridge.getImplClassLoader();
        try {
            Class<?> corridCallbackClass = implClassLoader.loadClass(IMPL_CORR_ID_INTERCEPTOR);
            Object instance = corridCallbackClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.requestProcessorChainInterceptor = (RequestProcessorChainInterceptor)instance;
        }
        catch (ClassCastException | LinkageError | ReflectiveOperationException e) {
            throw new LifecycleException("Failed to initialize the correlation-id generating valve.", e);
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.requestProcessorChainInterceptor.aroundRequest(this, request, response);
    }

    @Override
    public void process(Request request, Response response) throws IOException, ServletException {
        Valve nextValve = this.getNext();
        if (null != nextValve) {
            nextValve.invoke(request, response);
        }
    }
}

