/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.client.operation.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sap.core.extensions.service.cmd.client.operation.ApplicationAccess;
import com.sap.core.extensions.service.cmd.client.operation.BadOperationRequestException;
import com.sap.core.extensions.service.cmd.client.operation.Connection;
import com.sap.core.extensions.service.cmd.client.operation.ConnectionParams;
import com.sap.core.extensions.service.cmd.client.operation.DeleteConnectionParams;
import com.sap.core.extensions.service.cmd.client.operation.DeletedArtifactsData;
import com.sap.core.extensions.service.cmd.client.operation.EnableRoleProviderParams;
import com.sap.core.extensions.service.cmd.client.operation.ErrorResponseBean;
import com.sap.core.extensions.service.cmd.client.operation.ImportRolesResult;
import com.sap.core.extensions.service.cmd.client.operation.ListTilesResultDTO;
import com.sap.core.extensions.service.cmd.client.operation.OAuthDestination;
import com.sap.core.extensions.service.cmd.client.operation.Operation;
import com.sap.core.extensions.service.cmd.client.operation.OperationClientException;
import com.sap.core.extensions.service.cmd.client.operation.OperationServiceClient;
import com.sap.core.extensions.service.cmd.client.operation.RegisterTilesResultDTO;
import com.sap.core.extensions.service.cmd.client.operation.SubscriptionParams;
import com.sap.core.extensions.service.cmd.client.operation.TypeApplicationParams;
import com.sap.core.extensions.service.cmd.client.operation.UnauthorizedException;
import com.sap.core.extensions.service.cmd.client.operation.UnregisterTilesResultDTO;
import com.sap.core.extensions.service.cmd.client.operation.impl.ConnectionRequest;
import com.sap.core.extensions.service.cmd.client.operation.impl.DeleteConnectionParamsRequest;
import com.sap.core.extensions.service.cmd.client.operation.impl.LocationApplicationRequest;
import com.sap.core.extensions.service.cmd.client.operation.impl.OperationsURICreator;
import com.sap.core.extensions.service.cmd.client.operation.impl.SubscriptionParamsRequest;
import com.sap.core.extensions.service.cmd.client.operation.impl.TypeApplicationParamsRequest;
import com.sap.core.extensions.service.cmd.client.operation.impl.UnexpectedStatusCodeException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.EntityUtils;

public class OperationServiceClientImpl
implements OperationServiceClient {
    private static final char PATH_DELIMITER = '/';
    private static final String NO_LOCATION_HEADER_ERR_MSG = "No location header returned from Operations API";
    private static final String TOO_MANY_LOCATION_HEADERS_ERR_MSG = "Too many location headers returned from the Operations API.";
    private static final String UNAUTHORIZED_ERROR_MSG = "User is unauthorized to perform operation";
    private static final String OPERATION_CREATION_FAILED_GENERIC_ERROR_MSG = "Failed to create operation in the Operations API.";
    private static final String OPERATION_RETRIEVAL_ERROR_MSG = "Could not obtain operation.";
    private static final String OPERATION_RESOURCE_UPLOAD_FAILURE_ERROR_MSG_PATTERN = "Failed to upload resource '%s'.";
    private static final String OPERATION_RESOURCE_UPLOAD_FAILURE_GENERIC_ERROR_MSG = "Failed to upload an operation resource.";
    private static final String CREATE_CONNECTION_OPERATION_NAME = "hcmcloud-create-connection";
    private static final String LIST_CONNECTIONS_OPERATION_NAME = "hcmcloud-list-connections";
    private static final String DISPLAY_ACCESS_OPERATION_NAME = "hcmcloud-display-application-access-status";
    private static final String REGISTER_HOME_PAGE_TILE_CMD_NAME = "hcmcloud-register-home-page-tiles";
    private static final String ENABLE_APP_ACCESS_OPERATION_NAME = "hcmcloud-enable-application-access";
    private static final String DISABLE_APP_ACCESS_OPERATION_NAME = "hcmcloud-disable-application-access";
    private static final String DELETE_CONNECTION_OPERATION_NAME = "hcmcloud-delete-connection";
    private static final String LIST_TILES_OPERATION_NAME = "hcmcloud-get-registered-home-page-tiles";
    private static final String ENABLE_ROLE_RPOVIDER_OPERATION_NAME = "hcmcloud-enable-role-provider";
    private static final String UNREGISTER_TILES_OPERATION_NAME = "hcmcloud-unregister-home-page-tiles";
    private static final String IMPORT_ROLES_OPERATION_NAME = "hcmcloud-import-roles";
    private static final String ROLES_RESOURCE = "roles";
    private static final String TILES_RESOURCE = "tiles";
    private static final String OPERATION_RESOURCE_NAME = "operationResource";
    private final HttpClient client;
    private final Gson gson;
    private final OperationsURICreator operationsURICreator;

    public OperationServiceClientImpl(HttpClient client, String landscapeHost) {
        this.client = client;
        this.gson = new Gson();
        this.operationsURICreator = new OperationsURICreator(landscapeHost);
    }

    @Override
    public long createConfigureConnectionOperation(String accountId, ConnectionParams connectionParams) {
        ConnectionRequest request = new ConnectionRequest(connectionParams.getApplication(), connectionParams.getProviderAccount(), connectionParams.getTechnicalUser(), connectionParams.isOverwrite(), connectionParams.getConnectionName());
        return this.createOperation(accountId, CREATE_CONNECTION_OPERATION_NAME, request);
    }

    @Override
    public Operation<OAuthDestination> getConfigureConnectionOperation(String accountId, long operationId) {
        return this.getOperation(accountId, CREATE_CONNECTION_OPERATION_NAME, operationId, new TypeToken<Operation<OAuthDestination>>(){});
    }

    @Override
    public long createListConnectionsOperation(String account, SubscriptionParams subscriptionParams) {
        SubscriptionParamsRequest request = new SubscriptionParamsRequest(subscriptionParams.getApplication(), subscriptionParams.getProviderAccount());
        return this.createOperation(account, LIST_CONNECTIONS_OPERATION_NAME, request);
    }

    @Override
    public Operation<List<Connection>> getListConnectionsOperation(String account, long operationId) {
        return this.getOperation(account, LIST_CONNECTIONS_OPERATION_NAME, operationId, new TypeToken<Operation<List<Connection>>>(){});
    }

    @Override
    public long createDeleteConnectionOperation(String accountId, DeleteConnectionParams operationParams) {
        DeleteConnectionParamsRequest request = new DeleteConnectionParamsRequest(operationParams.getApplication(), operationParams.getProviderAccount(), operationParams.getConnectionName());
        return this.createOperation(accountId, DELETE_CONNECTION_OPERATION_NAME, request);
    }

    @Override
    public Operation<DeletedArtifactsData> getDeleteConnectionOperation(String accountId, long operationId) {
        return this.getOperation(accountId, DELETE_CONNECTION_OPERATION_NAME, operationId, new TypeToken<Operation<DeletedArtifactsData>>(){});
    }

    @Override
    public long createDisplayAccessOperation(String accountId, TypeApplicationParams params) {
        TypeApplicationParamsRequest request = new TypeApplicationParamsRequest(params.getApplication(), params.getProviderAccount(), params.getApplicationType());
        return this.createOperation(accountId, DISPLAY_ACCESS_OPERATION_NAME, request);
    }

    @Override
    public Operation<List<ApplicationAccess>> getDisplayAccessOperation(String accountId, long operationId) {
        return this.getOperation(accountId, DISPLAY_ACCESS_OPERATION_NAME, operationId, new TypeToken<Operation<List<ApplicationAccess>>>(){});
    }

    @Override
    public long createEnableAccessOperation(String accountId, TypeApplicationParams params) {
        TypeApplicationParamsRequest request = new TypeApplicationParamsRequest(params.getApplication(), params.getProviderAccount(), params.getApplicationType());
        return this.createOperation(accountId, ENABLE_APP_ACCESS_OPERATION_NAME, request);
    }

    @Override
    public Operation<ApplicationAccess> getEnableAccessOperation(String accountId, long operationId) {
        return this.getOperation(accountId, ENABLE_APP_ACCESS_OPERATION_NAME, operationId, new TypeToken<Operation<ApplicationAccess>>(){});
    }

    @Override
    public long createDisableApplicationAccessOperation(String accountId, TypeApplicationParams params) {
        TypeApplicationParamsRequest request = new TypeApplicationParamsRequest(params.getApplication(), params.getProviderAccount(), params.getApplicationType());
        return this.createOperation(accountId, DISABLE_APP_ACCESS_OPERATION_NAME, request);
    }

    @Override
    public Operation<List<ApplicationAccess>> getDisableApplicationAccessOperation(String accountId, long operationId) {
        return this.getOperation(accountId, DISABLE_APP_ACCESS_OPERATION_NAME, operationId, new TypeToken<Operation<List<ApplicationAccess>>>(){});
    }

    @Override
    public long createRegisterTilesOperation(String account, TypeApplicationParams applicationParams, String location) {
        LocationApplicationRequest request = new LocationApplicationRequest(applicationParams);
        long createdOperationId = this.createOperation(account, REGISTER_HOME_PAGE_TILE_CMD_NAME, request);
        String tilesURI = this.operationsURICreator.createOperationResourceURI(account, REGISTER_HOME_PAGE_TILE_CMD_NAME, createdOperationId, TILES_RESOURCE);
        this.uploadOperationResource(tilesURI, location);
        return createdOperationId;
    }

    @Override
    public Operation<RegisterTilesResultDTO> getRegisterTilesOperation(String account, long operationId) {
        return this.getOperation(account, REGISTER_HOME_PAGE_TILE_CMD_NAME, operationId, new TypeToken<Operation<RegisterTilesResultDTO>>(){});
    }

    @Override
    public long createListTilesOperation(String accountId, TypeApplicationParams operationParams) {
        TypeApplicationParamsRequest request = new TypeApplicationParamsRequest(operationParams.getApplication(), operationParams.getProviderAccount(), operationParams.getApplicationType());
        return this.createOperation(accountId, LIST_TILES_OPERATION_NAME, request);
    }

    @Override
    public Operation<ListTilesResultDTO> getListTilesOperation(String accountId, long operationId) {
        return this.getOperation(accountId, LIST_TILES_OPERATION_NAME, operationId, new TypeToken<Operation<ListTilesResultDTO>>(){});
    }

    @Override
    public long createUnregisterTilesOperation(String accountId, TypeApplicationParams operationParams) {
        TypeApplicationParamsRequest request = new TypeApplicationParamsRequest(operationParams.getApplication(), operationParams.getProviderAccount(), operationParams.getApplicationType());
        return this.createOperation(accountId, UNREGISTER_TILES_OPERATION_NAME, request);
    }

    @Override
    public Operation<UnregisterTilesResultDTO> getUnregisterTilesOperation(String accountId, long operationId) {
        return this.getOperation(accountId, UNREGISTER_TILES_OPERATION_NAME, operationId, new TypeToken<Operation<UnregisterTilesResultDTO>>(){});
    }

    @Override
    public long createEnableRoleProviderOperation(String accountId, EnableRoleProviderParams enableRoleProviderParams) {
        EnableRoleProviderParams request = new EnableRoleProviderParams(enableRoleProviderParams.getApplication(), enableRoleProviderParams.getProviderAccount(), enableRoleProviderParams.getConnectionName());
        return this.createOperation(accountId, ENABLE_ROLE_RPOVIDER_OPERATION_NAME, request);
    }

    @Override
    public Operation<Void> getEnableRoleProviderOperation(String accountId, long operationId) {
        return this.getOperation(accountId, ENABLE_ROLE_RPOVIDER_OPERATION_NAME, operationId, new TypeToken<Operation<Void>>(){});
    }

    @Override
    public long createImportRolesOperation(String accountId, String rolesFilePath) {
        long createdOperationId = this.createOperation(accountId, IMPORT_ROLES_OPERATION_NAME, null);
        String rolesURI = this.operationsURICreator.createOperationResourceURI(accountId, IMPORT_ROLES_OPERATION_NAME, createdOperationId, ROLES_RESOURCE);
        this.uploadOperationResource(rolesURI, rolesFilePath);
        return createdOperationId;
    }

    @Override
    public Operation<ImportRolesResult> getImportRolesOperation(String accountId, long operationId) {
        return this.getOperation(accountId, IMPORT_ROLES_OPERATION_NAME, operationId, new TypeToken<Operation<ImportRolesResult>>(){});
    }

    private long createOperation(String accountId, String operationName, Object operationParamsBean) throws OperationClientException {
        String createOperationURI = this.operationsURICreator.createOperationsURI(accountId, operationName);
        HttpPost createOperationRequest = new HttpPost(createOperationURI);
        if (null != operationParamsBean) {
            String paramsJson = this.gson.toJson(operationParamsBean);
            createOperationRequest.setEntity((HttpEntity)new StringEntity(paramsJson, ContentType.APPLICATION_JSON));
        }
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)createOperationRequest);
            return this.handleCreatedResponse(response);
        }
        catch (IOException e) {
            throw new OperationClientException(OPERATION_CREATION_FAILED_GENERIC_ERROR_MSG, e);
        }
    }

    private long handleCreatedResponse(HttpResponse response) throws IOException, BadOperationRequestException {
        this.validateStatusCode(response, 201, OPERATION_CREATION_FAILED_GENERIC_ERROR_MSG);
        return this.extractOperationId(response);
    }

    private void validateStatusCode(HttpResponse response, int expectedStatusCode, String genericErrorMessage) throws IOException {
        int returnedStatusCode = response.getStatusLine().getStatusCode();
        if (returnedStatusCode == 401 || returnedStatusCode == 403) {
            throw new UnauthorizedException(UNAUTHORIZED_ERROR_MSG);
        }
        if (returnedStatusCode == 400) {
            ErrorResponseBean responseBean = this.extractErrorResponse(response);
            throw new BadOperationRequestException(responseBean);
        }
        if (returnedStatusCode != expectedStatusCode) {
            throw new UnexpectedStatusCodeException(genericErrorMessage, returnedStatusCode, expectedStatusCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorResponseBean extractErrorResponse(HttpResponse response) throws IOException {
        try {
            String responseJson = EntityUtils.toString((HttpEntity)response.getEntity());
            ErrorResponseBean responseBean = (ErrorResponseBean)this.gson.fromJson(responseJson, ErrorResponseBean.class);
            ErrorResponseBean errorResponseBean = null == responseBean ? new ErrorResponseBean() : responseBean;
            return errorResponseBean;
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
    }

    private long extractOperationId(HttpResponse response) {
        Header[] locationHeaders = response.getHeaders("Location");
        if (locationHeaders == null || locationHeaders.length < 1 || locationHeaders[0].getValue() == null || locationHeaders[0].getValue().isEmpty()) {
            throw new IllegalStateException(NO_LOCATION_HEADER_ERR_MSG);
        }
        if (locationHeaders.length > 1) {
            throw new IllegalStateException(TOO_MANY_LOCATION_HEADERS_ERR_MSG);
        }
        String operationLocationURI = locationHeaders[0].getValue();
        String operationId = operationLocationURI.substring(operationLocationURI.lastIndexOf(47) + 1);
        return Long.parseLong(operationId);
    }

    private void uploadOperationResource(String resourceURI, String resourceFilePath) {
        HttpPost post = new HttpPost(resourceURI);
        HttpEntity entity = this.createResourceEntity(resourceFilePath);
        post.setEntity(entity);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            this.validateStatusCode(response, 204, OPERATION_RESOURCE_UPLOAD_FAILURE_GENERIC_ERROR_MSG);
        }
        catch (IOException ex) {
            String errMessage = String.format(OPERATION_RESOURCE_UPLOAD_FAILURE_ERROR_MSG_PATTERN, resourceFilePath);
            throw new OperationClientException(errMessage, ex);
        }
    }

    private HttpEntity createResourceEntity(String resourceFilePath) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        File resourceFile = new File(resourceFilePath);
        FileBody resourceFileBody = new FileBody(resourceFile);
        multipartEntityBuilder.addPart(OPERATION_RESOURCE_NAME, (ContentBody)resourceFileBody);
        return multipartEntityBuilder.build();
    }

    private <R> Operation<R> getOperation(String accountId, String operationName, long operationId, TypeToken<Operation<R>> responseType) {
        String operationURI = this.operationsURICreator.createOperationURI(accountId, operationName, operationId);
        HttpGet getOperation = new HttpGet(operationURI);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)getOperation);
            this.validateStatusCode(response, 200, OPERATION_RETRIEVAL_ERROR_MSG);
            return this.deserializeOperationResponse(response, responseType);
        }
        catch (IOException e) {
            throw new OperationClientException(OPERATION_RETRIEVAL_ERROR_MSG, e);
        }
    }

    private <R> Operation<R> deserializeOperationResponse(HttpResponse response, TypeToken<Operation<R>> responseType) throws ParseException, IOException {
        String operationJson = EntityUtils.toString((HttpEntity)response.getEntity());
        return (Operation)this.gson.fromJson(operationJson, responseType.getType());
    }
}

