/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.extensions.service.cmd.client.operation.impl;

import com.sap.core.extensions.service.cmd.client.operation.impl.ExtensionServiceLocationProvider;
import java.net.MalformedURLException;
import java.net.URL;

class OperationsURICreator {
    private static final String OPERATIONS_API_PATH_PATTERN = "https://%s.%s/rest/api/v1/";
    private static final String OPERATIONS_PATTERN = "https://%s.%s/rest/api/v1/accounts/%s/operations/%s";
    private static final String OPERATION_PATTERN = "https://%s.%s/rest/api/v1/accounts/%s/operations/%s/%d";
    private static final String OPERATION_RESOURCE_PATTERN = "https://%s.%s/rest/api/v1/accounts/%s/operations/%s/%d/%s";
    private final String landscapeHost;
    private ExtensionServiceLocationProvider extensionServiceLocationProvider;

    OperationsURICreator(String landscapeHost) {
        this(landscapeHost, new ExtensionServiceLocationProvider());
    }

    OperationsURICreator(String landscapeHost, ExtensionServiceLocationProvider extensionServiceLocationProvider) {
        this.landscapeHost = this.getHost(landscapeHost);
        this.extensionServiceLocationProvider = extensionServiceLocationProvider;
    }

    private String getHost(String cmdLandscapeHost) {
        try {
            return new URL(cmdLandscapeHost).getHost();
        }
        catch (MalformedURLException e) {
            return cmdLandscapeHost;
        }
    }

    public String createOperationsURI(String account, String operationName) {
        String extSvcShortURI = this.extensionServiceLocationProvider.get().getShortURL();
        return String.format(OPERATIONS_PATTERN, extSvcShortURI, this.landscapeHost, account, operationName);
    }

    public String createOperationURI(String account, String operationName, long operationId) {
        String extSvcShortURI = this.extensionServiceLocationProvider.get().getShortURL();
        return String.format(OPERATION_PATTERN, extSvcShortURI, this.landscapeHost, account, operationName, operationId);
    }

    public String createOperationResourceURI(String account, String operationName, long operationId, String resource) {
        String extSvcShortURI = this.extensionServiceLocationProvider.get().getShortURL();
        return String.format(OPERATION_RESOURCE_PATTERN, extSvcShortURI, this.landscapeHost, account, operationName, operationId, resource);
    }
}

