/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.local;

import com.sap.core.connectivity.apiext.impl.datasource.FileSystemDataSource;
import com.sap.core.connectivity.apiext.local.crypto.DestinationPasswordEncryptDecrypt;
import com.sap.core.connectivity.apiext.local.crypto.exceptions.EncryptionCorruptedException;
import com.sap.core.connectivity.apiext.local.crypto.exceptions.EncryptionKeyNotFoundException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;

public class LocalFileSystemDataSource
extends FileSystemDataSource {
    protected Properties readDestinationProperties(File file) throws FileNotFoundException, IOException {
        DestinationPasswordEncryptDecrypt decrypter;
        Properties properties = super.readDestinationProperties(file);
        if (properties.containsKey("encryption-key-location") && (decrypter = DestinationPasswordEncryptDecrypt.getDefaultPasswordEncrypter((Properties)properties)) != null) {
            try {
                decrypter.decryptPasswordProperties(properties);
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
            catch (EncryptionCorruptedException e) {
                throw new IllegalArgumentException(e);
            }
            catch (EncryptionKeyNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return properties;
    }
}

