/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.local.html5;

import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.apiext.impl.configuration.HTML5AbstractConfiguration;
import com.sap.core.connectivity.apiext.impl.configuration.provider.HTML5ConfigurationProvider;
import com.sap.core.connectivity.apiext.impl.configuration.provider.HTML5ConfigurationProviderImpl;
import com.sap.core.connectivity.apiext.impl.configuration.reader.HTML5ConfigurationReader;
import com.sap.core.connectivity.apiext.impl.configuration.reader.HTML5DataSourceConfigurationReader;
import com.sap.core.connectivity.apiext.impl.datasource.HTML5DataSource;
import com.sap.core.connectivity.apiext.impl.keystore.KeyStoreFactory;
import com.sap.core.connectivity.apiext.impl.util.JavaServiceLoader;
import com.sap.core.connectivity.apiext.local.LocalKeyStoreFactory;
import com.sap.core.connectivity.apiext.local.html5.HTML5LocalDataSource;
import java.util.Map;

public class HTML5LocalConfiguration
extends HTML5AbstractConfiguration {
    private ConnectivityConfiguration connectivityConfiguration;

    public HTML5LocalConfiguration() {
        this(HTML5LocalConfiguration.createConfigurationProvider());
    }

    public HTML5LocalConfiguration(HTML5ConfigurationProvider configurationProvider) {
        super(configurationProvider);
    }

    private static HTML5ConfigurationProvider createConfigurationProvider() {
        HTML5ConfigurationReader configurationReader = HTML5LocalConfiguration.createConfigurationReader();
        return new HTML5ConfigurationProviderImpl(configurationReader, (KeyStoreFactory)new LocalKeyStoreFactory());
    }

    private static HTML5ConfigurationReader createConfigurationReader() {
        HTML5LocalDataSource dataSource = new HTML5LocalDataSource();
        return new HTML5DataSourceConfigurationReader((HTML5DataSource)dataSource);
    }

    protected void setConnectivityConfiguration(ConnectivityConfiguration connectivityConfiguration) {
        this.connectivityConfiguration = connectivityConfiguration;
    }

    protected void unsetConnectivityConfiguration(ConnectivityConfiguration connectivityConfiguration) {
        this.connectivityConfiguration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectivityConfiguration getConnectivityConfiguration() {
        if (this.connectivityConfiguration == null) {
            HTML5LocalConfiguration hTML5LocalConfiguration = this;
            synchronized (hTML5LocalConfiguration) {
                if (this.connectivityConfiguration == null) {
                    this.connectivityConfiguration = (ConnectivityConfiguration)JavaServiceLoader.load(ConnectivityConfiguration.class, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                }
            }
        }
        if (this.connectivityConfiguration == null) {
            throw new IllegalStateException("Connectivity Configuration missing");
        }
        return this.connectivityConfiguration;
    }

    public Map<String, DestinationConfiguration> getConfigurations(String accountId) {
        return this.getConnectivityConfiguration().getConfigurations(accountId);
    }
}

