/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.JsonBodyResponse;
import com.sap.cloud.security.oauth2.as.commons.json.JsonIgnore;
import java.util.Map;

public class ErrorResponse
extends JsonBodyResponse {
    private ErrorCode error;
    private String error_description;
    private String error_uri;
    @JsonIgnore
    private Map<String, String> headers;
    @JsonIgnore
    private int httpCode;

    public String getError_uri() {
        return this.error_uri;
    }

    public static ErrorResponse getInstance(ErrorCode errorCode, String errorDescription, String errorUri, Map<String, String> headers, int httpCode) {
        return new ErrorResponse(errorCode, errorDescription, errorUri, headers, httpCode);
    }

    public static ErrorResponse getBadRequestInstance(ErrorCode errorCode, String errorDescription, String errorUri) {
        return ErrorResponse.getInstance(errorCode, errorDescription, errorUri, null, 400);
    }

    public static ErrorResponse getInternalServerErrorInstance(String errorDescription, String errorUri) {
        return ErrorResponse.getInstance(ErrorCode.server_error, errorDescription, errorUri, null, 500);
    }

    private ErrorResponse(ErrorCode errorCode, String errorDescription, String errorUri, Map<String, String> headers, int httpCode) {
        this.error = errorCode;
        this.error_description = errorDescription;
        this.error_uri = errorUri;
        this.headers = headers;
        this.httpCode = httpCode;
    }

    @Override
    public Map<String, String> getAdditionalHeadersToAdd() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setError_uri(String error_uri) {
        this.error_uri = error_uri;
    }

    public String getError_description() {
        return this.error_description;
    }

    public void setError_description(String error_description) {
        this.error_description = error_description;
    }

    public ErrorCode getErrorCode() {
        return this.error;
    }

    public void setErrorCode(ErrorCode error) {
        this.error = error;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public void setHttpCode(int statusCode) {
        this.httpCode = statusCode;
    }

    @Override
    protected int getStatusCode() {
        return this.httpCode;
    }

    @Override
    public String getEntity() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("error", this.getErrorCode().name());
        jsonObject.addProperty("error_description", this.getError_description());
        jsonObject.addProperty("error_uri", this.getError_uri());
        return new Gson().toJson((JsonElement)jsonObject);
    }
}

