/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.client;

import com.google.gson.annotations.Expose;
import com.sap.cloud.security.oauth2.as.commons.client.ClientType;
import com.sap.cloud.security.oauth2.as.commons.client.IResourceServer;
import com.sap.cloud.security.oauth2.as.commons.json.JsonIgnore;
import com.sap.cloud.security.oauth2.as.commons.scopes.ScopeInfo;
import com.sap.cloud.security.oauth2.commons.client.IClientContext;
import java.util.HashSet;
import java.util.Set;

public class BasicClientInfo {
    @Expose
    private String clientid;
    private int authzcodeexpiresin;
    private ClientType clienttype;
    private String redirecturi;
    private int refreshtokenexpiresin;
    @JsonIgnore
    private String secret;
    @JsonIgnore
    private String secretsalt;
    private int secretexpiresin;
    private long secretissuedat;
    private int tokenexpiresin;
    private String url;
    private String authorities;
    @Expose
    private String description;
    @Expose
    private Set<ScopeInfo> scopes = new HashSet<ScopeInfo>();
    protected IResourceServer resourceServer;
    protected IClientContext context;
    private boolean skipAuthorizationConsentScreenEnabled;

    public boolean isSkipAuthorizationConsentScreenEnabled() {
        return this.skipAuthorizationConsentScreenEnabled;
    }

    public void setSkipAuthorizationConsentScreenEnabled(boolean skipAuthorizationConsentScreenEnabled) {
        this.skipAuthorizationConsentScreenEnabled = skipAuthorizationConsentScreenEnabled;
    }

    public IResourceServer getResourceServer() {
        return this.resourceServer;
    }

    public void setResourceServer(IResourceServer resourceServer) {
        this.resourceServer = resourceServer;
    }

    public IClientContext getContext() {
        return this.context;
    }

    public void setContext(IClientContext context) {
        this.context = context;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ClientType getClientType() {
        return this.clienttype;
    }

    public void setClientType(ClientType clientType) {
        this.clienttype = clientType;
    }

    public String getRedirectUri() {
        return this.redirecturi;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirecturi = redirectUri;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getTokenExpiresIn() {
        return this.tokenexpiresin;
    }

    public void setTokenExpiresIn(int tokenExpiresIn) {
        this.tokenexpiresin = tokenExpiresIn;
    }

    public long getSecretIssuedAt() {
        return this.secretissuedat;
    }

    public void setSecretIssuedAt(long secretIssueDat) {
        this.secretissuedat = secretIssueDat;
    }

    public int getSecretExpiresIn() {
        return this.secretexpiresin;
    }

    public void setSecretExpiresIn(int secretExpiresIn) {
        this.secretexpiresin = secretExpiresIn;
    }

    public int getRefreshTokenExpiresIn() {
        return this.refreshtokenexpiresin;
    }

    public void setRefreshTokenExpiresIn(int refreshTokenExpiresIn) {
        this.refreshtokenexpiresin = refreshTokenExpiresIn;
    }

    public int getAuthzCodeExpiresIn() {
        return this.authzcodeexpiresin;
    }

    public void setAuthzCodeExpiresIn(int authzCodeExpiresIn) {
        this.authzcodeexpiresin = authzCodeExpiresIn;
    }

    public String getSecretSalt() {
        return this.secretsalt;
    }

    public void setSecretSalt(String secretsalt) {
        this.secretsalt = secretsalt;
    }

    public String getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(String authorities) {
        this.authorities = authorities;
    }

    public String getClientId() {
        return this.clientid;
    }

    public void setClientId(String clientid) {
        this.clientid = clientid;
    }

    public Set<ScopeInfo> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<ScopeInfo> scopes) {
        this.scopes = scopes;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean containsAllScopes(String[] requestedScopes) {
        if (this.scopes == null) {
            return false;
        }
        String[] stringArray = requestedScopes;
        int n = requestedScopes.length;
        int n2 = 0;
        while (n2 < n) {
            String requestedScope = stringArray[n2];
            if (!this.scopeIsAssigned(requestedScope)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean scopeIsAssigned(String requestedScope) {
        for (ScopeInfo scope : this.scopes) {
            String scopeName = this.constructScopeName(scope);
            if (!requestedScope.equals(scopeName)) continue;
            return true;
        }
        return false;
    }

    private String constructScopeName(ScopeInfo scope) {
        if (scope.getResourceServerUri() == null) {
            return scope.getId();
        }
        return String.valueOf(scope.getResourceServerUri()) + "." + scope.getId();
    }

    public Set<ScopeInfo> getAllScopesMatching(String[] requestedScopes) {
        HashSet<ScopeInfo> matchedScopes = new HashSet<ScopeInfo>();
        String[] stringArray = requestedScopes;
        int n = requestedScopes.length;
        int n2 = 0;
        while (n2 < n) {
            String requestedScope = stringArray[n2];
            for (ScopeInfo scope : this.scopes) {
                String scopeName = this.constructScopeName(scope);
                if (!requestedScope.equals(scopeName)) continue;
                matchedScopes.add(scope);
            }
            ++n2;
        }
        return matchedScopes;
    }

    public String toString() {
        return "BasicClientInfo [id=" + this.getClientId() + ", secret=..., secretsalt=..., secretIssuedAt=" + this.secretissuedat + ", secretExpiresIn=" + this.secretexpiresin + ", type=" + (Object)((Object)this.clienttype) + ", redirectURI=" + this.redirecturi + ", url=" + this.url + ", tokenExpiresIn=" + this.tokenexpiresin + ", refreshTokenExpiresIn=" + this.refreshtokenexpiresin + ", authzCodeExpiresIn=" + this.authzcodeexpiresin + ", scopes=" + this.getScopes() + ", authorities=" + this.authorities + ", description=" + this.description + ", skipAuthorizationConsentScreenEnabled=" + this.skipAuthorizationConsentScreenEnabled + "]";
    }
}

