/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.client;

import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.ClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.ClientType;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.utils.ValueGenerator;
import com.sap.cloud.security.oauth2.commons.logging.CommonLogger;
import com.sap.cloud.security.oauth2.commons.logging.CommonLoggerFactory;
import java.util.Calendar;
import java.util.List;

public class ClientAccessorHelper {
    private static final CommonLogger logger = CommonLoggerFactory.getLogger(ClientAccessorHelper.class);

    public static void populateClientInfo(ClientInfo clientInfo, IClientAccessor accessor) throws InternalErrorException {
        List<BasicClientInfo> clientInfos = accessor.getClients();
        String clientID = ClientAccessorHelper.generateClientId(clientInfos);
        if (clientID == null) {
            throw new InternalErrorException("Client cannot be registered because new clientId was not generated.");
        }
        long secretIssuedAt = 0L;
        int secretExpiresIn = 0;
        if (clientInfo.getClientType() == ClientType.CONFIDENTIAL) {
            secretIssuedAt = Calendar.getInstance().getTimeInMillis();
            secretExpiresIn = clientInfo.getSecretExpiresIn();
        }
        clientInfo.setSecretExpiresIn(secretExpiresIn);
        clientInfo.setSecretIssuedAt(secretIssuedAt);
        clientInfo.setClientId(clientID);
    }

    private static String generateClientId(List<BasicClientInfo> clientInfos) {
        String clientId = null;
        boolean alreadyRegistered = false;
        int attempt = 0;
        block0: do {
            ++attempt;
            alreadyRegistered = false;
            clientId = ValueGenerator.generateValue();
            for (BasicClientInfo clientInfo : clientInfos) {
                if (!clientId.equals(clientInfo.getClientId())) continue;
                alreadyRegistered = true;
                continue block0;
            }
        } while (alreadyRegistered && attempt < 5);
        if (logger.isDebugEnabled()) {
            logger.debug("Generated clientId was: " + clientId);
        }
        return clientId;
    }
}

