/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.client;

public enum ClientType {
    CONFIDENTIAL("confidential"),
    PUBLIC("public");

    private final String value;

    private ClientType(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static ClientType fromValue(String v) {
        if (v == null) {
            throw new IllegalArgumentException("Client Type value cannot be null");
        }
        ClientType[] clientTypeArray = ClientType.values();
        int n = clientTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType c = clientTypeArray[n2];
            if (c.value.equalsIgnoreCase(v)) {
                return c;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Client Type with the following value does not exist:" + v.toString());
    }

    public String toString() {
        return this.value;
    }
}

