/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.code;

import com.sap.cloud.security.oauth2.as.commons.scopes.ScopeInfo;
import com.sap.cloud.security.oauth2.commons.LoggerHelper;
import com.sap.cloud.security.oauth2.commons.token.UserInfo;
import java.util.Set;

public class AuthzCodeInfo {
    private String authorization_code;
    private String originalCode;
    private String client_id;
    private String redirect_uri;
    private String user_id;
    private long issuedAt = 0L;
    private UserInfo userInfo;
    private Set<ScopeInfo> scopes;

    public AuthzCodeInfo(String code, String originalCode, String clientId, String userId, long timeInMillis, Set<ScopeInfo> scopes, String redirectURI, UserInfo userInfo) {
        this.authorization_code = code;
        this.originalCode = originalCode;
        if (originalCode == null) {
            this.originalCode = code;
        }
        this.client_id = clientId;
        this.user_id = userId;
        this.issuedAt = timeInMillis;
        this.scopes = scopes;
        this.redirect_uri = redirectURI;
        this.userInfo = userInfo;
    }

    public AuthzCodeInfo() {
        this.userInfo = new UserInfo();
    }

    public String getAuthorizationCode() {
        return this.authorization_code;
    }

    public void setAuthorizationCode(String authorization_code) {
        this.authorization_code = authorization_code;
    }

    public String getUserId() {
        return this.user_id;
    }

    public void setUserId(String user_id) {
        this.user_id = user_id;
    }

    public String getClientId() {
        return this.client_id;
    }

    public void setClientId(String client_id) {
        this.client_id = client_id;
    }

    public String getRedirectUri() {
        return this.redirect_uri;
    }

    public void setRedirectUri(String redirect_uri) {
        this.redirect_uri = redirect_uri;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
    }

    public Set<ScopeInfo> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<ScopeInfo> scopes) {
        this.scopes = scopes;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public String getOriginalCode() {
        return this.originalCode;
    }

    public void setOriginalCode(String originalCode) {
        this.originalCode = originalCode;
    }

    public boolean equals(Object obj) {
        return this.authorization_code != null && this.authorization_code.equals(((AuthzCodeInfo)obj).getAuthorizationCode());
    }

    public int hashCode() {
        int result = 45;
        int c = 0;
        if (this.authorization_code != null) {
            c = this.authorization_code.hashCode();
        }
        result = 37 * result + c;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[authorization_code=" + LoggerHelper.getTokenForLog((String)this.authorization_code) + "]\n");
        builder.append("[client_id=" + this.client_id + "]\n");
        builder.append("[redirect_uri=" + this.redirect_uri + "]\n");
        builder.append("[user_id=" + this.user_id + "]\n");
        builder.append("[issuedAt=" + this.issuedAt + "]\n");
        builder.append("[scopes=" + this.scopes + "]\n");
        builder.append("[userInfo=" + this.userInfo + "]\n");
        return builder.toString();
    }
}

