/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.code;

import com.sap.cloud.security.oauth2.as.commons.client.IResourceServer;
import com.sap.cloud.security.oauth2.as.commons.client.InternationalizedClientInfo;
import com.sap.cloud.security.oauth2.as.commons.code.AuthzCodeRequestScopes;

public class AuthzCodeReqData {
    public static final String responseTypeParamName = "response_type";
    public static final String clientIdParamName = "client_id";
    public static final String redirectURIParamName = "redirect_uri";
    public static final String scopeParamName = "scope";
    public static final String stateParamName = "state";
    public static final String autzRequestParamName = "authz_request_data";
    public static final String errorParamName = "authz_request_data_error";
    private String responseType;
    private String clientId;
    private String clientName;
    private IResourceServer resourceServer;
    private String redirectURI;
    private boolean isRedirectURIFromClient;
    private String state;
    private AuthzCodeRequestScopes scopes;

    AuthzCodeReqData(String responseType, InternationalizedClientInfo clientInfo, String redirectURI, boolean isRedirectURIFromClient, AuthzCodeRequestScopes scopes, String state) {
        this.responseType = responseType;
        this.scopes = scopes;
        this.clientId = clientInfo.getClientId();
        this.clientName = clientInfo.getName();
        this.resourceServer = clientInfo.getResourceServer();
        this.redirectURI = redirectURI;
        this.isRedirectURIFromClient = isRedirectURIFromClient;
        this.state = state;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientName() {
        return this.clientName;
    }

    public IResourceServer getResourceServer() {
        return this.resourceServer;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public boolean isRedirectURIFromClient() {
        return this.isRedirectURIFromClient;
    }

    public String getState() {
        return this.state;
    }

    public AuthzCodeRequestScopes getScopesData() {
        return this.scopes;
    }
}

