/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.code;

import com.sap.cloud.security.oauth2.as.commons.scopes.ScopeInfo;
import java.util.Set;

public class AuthzCodeRequestScopes {
    public static final String SCOPES_DELIMITER = ",";
    private Set<ScopeInfo> scopes;
    private Set<ScopeInfo> unrequestedScopes;

    public AuthzCodeRequestScopes(Set<ScopeInfo> scopes, Set<ScopeInfo> unrequestedScopes) {
        this.scopes = scopes;
        this.unrequestedScopes = unrequestedScopes;
    }

    public Set<ScopeInfo> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<ScopeInfo> scopes) {
        this.scopes = scopes;
    }

    public Set<ScopeInfo> getUnrequestedScopes() {
        return this.unrequestedScopes;
    }

    public void setUnrequestedScopes(Set<ScopeInfo> unrequestedScopes) {
        this.unrequestedScopes = unrequestedScopes;
    }

    public String getScopeIDs() {
        return this.join(this.scopes.toArray(new ScopeInfo[0]), SCOPES_DELIMITER);
    }

    public String getUnrequestedScopeIDs() {
        return this.join(this.unrequestedScopes.toArray(new ScopeInfo[0]), SCOPES_DELIMITER);
    }

    private String join(ScopeInfo[] array, String delim) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            sb.append(array[i].getId());
            if (i >= array.length - 1) break;
            sb.append(delim);
            ++i;
        }
        return sb.toString();
    }
}

