/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.code;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.client.InternationalizedClientInfo;
import com.sap.cloud.security.oauth2.as.commons.code.AuthzCodeReqData;
import com.sap.cloud.security.oauth2.as.commons.code.AuthzCodeRequestScopes;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.exception.OAuthAuthzCodeProblemException;
import com.sap.cloud.security.oauth2.as.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.as.commons.scopes.ScopeInfo;
import com.sap.cloud.security.oauth2.as.commons.utils.RedirectURIsChecker;
import com.sap.cloud.security.oauth2.commons.logging.CommonLogger;
import com.sap.cloud.security.oauth2.commons.logging.CommonLoggerFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class AuthzCodeRequestService {
    public static final String OAUTH_CODE = "code";
    private IClientAccessor clientsAccessor;
    private String requestRedirectURI;
    private String state;
    private String language;
    private String cientId;
    private String requestedScopes;
    private String responseType;
    private static final CommonLogger logger = CommonLoggerFactory.getLogger(AuthzCodeRequestService.class);

    public AuthzCodeRequestService(HttpServletRequest httpRequest, Map<String, List<String>> parameterMap, IClientAccessor clientsAccessor) {
        this.language = httpRequest.getLocale().getLanguage();
        this.state = parameterMap.get("state") == null ? null : parameterMap.get("state").get(0);
        this.cientId = parameterMap.get("client_id") == null ? null : parameterMap.get("client_id").get(0);
        this.requestRedirectURI = parameterMap.get("redirect_uri") == null ? null : parameterMap.get("redirect_uri").get(0);
        this.responseType = parameterMap.get("response_type") == null ? null : parameterMap.get("response_type").get(0);
        this.requestedScopes = parameterMap.get("scope") == null ? null : parameterMap.get("scope").get(0);
        this.clientsAccessor = clientsAccessor;
    }

    public AuthzCodeReqData getAuthzCodeRequest() throws OAuthAuthzCodeProblemException, InternalErrorException {
        String redirectUri = null;
        try {
            this.validateClientId();
            this.validateResponseType();
            InternationalizedClientInfo clientInfo = this.getRegisteredClientInfo(this.cientId, this.language);
            AuthzCodeRequestScopes validScopes = this.getValidatedScopes(clientInfo.getScopes());
            redirectUri = this.getValidRedirectURI(clientInfo.getRedirectUri());
            return new AuthzCodeReqData(this.responseType, clientInfo, redirectUri, this.requestRedirectURI == null, validScopes, this.state);
        }
        catch (OAuthProblemException e) {
            throw new OAuthAuthzCodeProblemException(e, this.state, redirectUri);
        }
    }

    private void validateClientId() throws OAuthProblemException, InternalErrorException {
        if (AuthzCodeRequestService.isEmpty(this.cientId)) {
            throw new OAuthProblemException("Missing client_id parameter value.", ErrorCode.invalid_request);
        }
    }

    private void validateResponseType() throws OAuthProblemException {
        if (AuthzCodeRequestService.isEmpty(this.responseType)) {
            throw new OAuthProblemException("Missing response_type parameter value.", ErrorCode.invalid_request);
        }
        if (!OAUTH_CODE.equalsIgnoreCase(this.responseType)) {
            throw new OAuthProblemException("Invalid response_type parameter value.", ErrorCode.unsupported_response_type);
        }
    }

    private InternationalizedClientInfo getRegisteredClientInfo(String clientID, String language) throws OAuthProblemException, InternalErrorException {
        InternationalizedClientInfo client = this.clientsAccessor.getInternationalizedClientByID(clientID, language);
        if (client == null) {
            throw new OAuthProblemException("Client is not registered.", ErrorCode.unauthorized_client);
        }
        return client;
    }

    private String getValidRedirectURI(String clientRedirectURI) throws OAuthProblemException {
        if (AuthzCodeRequestService.isEmpty(clientRedirectURI)) {
            throw new OAuthProblemException("Client has no configured redirect URI. Most probably a Client Credentials Flow client is used in authorization code flow.", ErrorCode.invalid_request);
        }
        if (AuthzCodeRequestService.isEmpty(this.requestRedirectURI)) {
            logger.debug("Redirect URI was not passed in the Authz Request, it is taken from the client registration.");
            return clientRedirectURI;
        }
        RedirectURIsChecker redirectURIsChecker = new RedirectURIsChecker(clientRedirectURI, this.requestRedirectURI);
        if (!redirectURIsChecker.isRequestAndClientRedirectURIsMatch()) {
            throw new OAuthProblemException("Specified redirect URI in the request does not match the redirect URI of the registered client.", ErrorCode.invalid_request);
        }
        return this.requestRedirectURI;
    }

    private AuthzCodeRequestScopes getValidatedScopes(Set<ScopeInfo> clientScopes) throws OAuthProblemException {
        Set<ScopeInfo> requestedValidScopes = this.getValidScopes(this.requestedScopes, clientScopes);
        Set<ScopeInfo> unrequestedScopes = this.getUnrequestedScopes(clientScopes, requestedValidScopes);
        return new AuthzCodeRequestScopes(requestedValidScopes, unrequestedScopes);
    }

    private Set<ScopeInfo> getValidScopes(String requestedScopes, Set<ScopeInfo> clientScopes) throws OAuthProblemException {
        HashSet<ScopeInfo> scopes = new HashSet<ScopeInfo>();
        if (!AuthzCodeRequestService.isEmpty(requestedScopes)) {
            StringTokenizer tokenizer = new StringTokenizer(requestedScopes, " ");
            while (tokenizer.hasMoreElements()) {
                boolean found = false;
                String scopeId = tokenizer.nextToken();
                for (ScopeInfo scopeInfo : clientScopes) {
                    if (!scopeInfo.getId().equals(scopeId)) continue;
                    scopes.add(scopeInfo);
                    found = true;
                    break;
                }
                if (found) continue;
                logger.debug("Requested scopes: [{}] no found in registered scopes [{}]", new Object[]{scopeId, clientScopes});
                throw new OAuthProblemException("Not all requested scopes are registered.", ErrorCode.invalid_scope);
            }
        }
        return scopes;
    }

    private Set<ScopeInfo> getUnrequestedScopes(Set<ScopeInfo> clientScopes, Set<ScopeInfo> requestedScopes) {
        HashSet<ScopeInfo> unrequestedScopes = new HashSet<ScopeInfo>();
        unrequestedScopes.addAll(clientScopes);
        if (requestedScopes == null || requestedScopes.size() == 0) {
            return unrequestedScopes;
        }
        for (ScopeInfo scopeInfo : requestedScopes) {
            if (!clientScopes.contains(scopeInfo)) continue;
            unrequestedScopes.remove(scopeInfo);
        }
        return unrequestedScopes;
    }

    private static boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }

    public static final class HttpMethod {
        public static final String POST = "POST";
        public static final String GET = "GET";
    }
}

