/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.code.userinfo;

import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.commons.PrincipalExtractor;
import com.sap.cloud.security.oauth2.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.commons.logging.CommonLogger;
import com.sap.cloud.security.oauth2.commons.logging.CommonLoggerFactory;
import com.sap.security.saml2.commons.SAML2Principal;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;

public class SAMLPrincipalExtractor {
    private static final CommonLogger logger = CommonLoggerFactory.getLogger(SAMLPrincipalExtractor.class);
    private static final String ERROR_MESSAGE_PREFIX = "Cannot extract SAML Principal.";
    private PrincipalExtractor generalPrincipalExtractor;
    private HttpServletRequest request;

    public SAMLPrincipalExtractor(HttpServletRequest request) {
        this.request = request;
        this.generalPrincipalExtractor = this.getGeneralPrincipalExtractor();
    }

    protected PrincipalExtractor getGeneralPrincipalExtractor() {
        return new PrincipalExtractor(this.request);
    }

    public SAML2Principal getPrincipal() throws InternalErrorException {
        Principal principal;
        try {
            principal = this.generalPrincipalExtractor.getPrincipal();
        }
        catch (OAuthProblemException e) {
            throw new InternalErrorException(ERROR_MESSAGE_PREFIX, e);
        }
        if (!SAML2Principal.class.isAssignableFrom(principal.getClass())) {
            logger.error("Unrecognised principal class " + principal.getClass().getCanonicalName());
            throw new InternalErrorException(ERROR_MESSAGE_PREFIX);
        }
        return (SAML2Principal)principal;
    }
}

