/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.token.accesstoken;

import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.scopes.ScopeInfo;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenAuthzCodeRequest;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenCCRequest;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenRefreshRequest;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenResponse;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenSAMLBearerRequest;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenValueGenerator;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.IAccessTokenAccessor;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.IRefreshTokenAccessor;
import java.util.HashSet;
import java.util.Set;

public class AccessTokenIssuer {
    private IAccessTokenAccessor accessTokenAccessor;
    private IRefreshTokenAccessor refresTokenAccessor;

    public AccessTokenIssuer(IAccessTokenAccessor accessTokenAccessor, IRefreshTokenAccessor refresTokenAccessor) {
        this.accessTokenAccessor = accessTokenAccessor;
        this.refresTokenAccessor = refresTokenAccessor;
    }

    public AccessTokenResponse issueToken(AccessTokenCCRequest ccRequest) {
        AccessTokenResponse generatedTokens = new AccessTokenValueGenerator().issueTokens();
        String newAccessTokenId = generatedTokens.getAccess_token();
        this.accessTokenAccessor.registerCCToken(ccRequest, newAccessTokenId);
        return this.createTokenResponse(newAccessTokenId, null, ccRequest.getScopes(), ccRequest.getClientInfo().getTokenExpiresIn());
    }

    private AccessTokenResponse createTokenResponse(String new_access_token, String new_refresh_token, Set<ScopeInfo> scopes, int tokenExpiresIn) {
        AccessTokenResponse tokenResponse = new AccessTokenResponse();
        tokenResponse.setAccess_token(new_access_token);
        tokenResponse.setRefresh_token(new_refresh_token);
        tokenResponse.setToken_type("Bearer");
        tokenResponse.setExpires_in(tokenExpiresIn);
        HashSet<String> scopeIds = new HashSet<String>();
        if (scopes != null) {
            for (ScopeInfo scopeInfo : scopes) {
                String scopeId = "";
                if (scopeInfo.getResourceServerUri() != null) {
                    scopeId = String.valueOf(scopeId) + scopeInfo.getResourceServerUri() + ".";
                }
                scopeId = String.valueOf(scopeId) + scopeInfo.getId();
                scopeIds.add(scopeId);
            }
        }
        tokenResponse.setScopes(scopeIds);
        return tokenResponse;
    }

    public AccessTokenResponse issueToken(AccessTokenAuthzCodeRequest authzCodeRequest) {
        AccessTokenResponse generatedTokens = new AccessTokenValueGenerator().issueTokens();
        String newAccessTokenId = generatedTokens.getAccess_token();
        String newRefreshTokenId = generatedTokens.getRefresh_token();
        this.accessTokenAccessor.registerAuthzCodeToken(authzCodeRequest, newAccessTokenId);
        this.refresTokenAccessor.registerAuthzCodeToken(authzCodeRequest, newRefreshTokenId);
        return this.createTokenResponse(newAccessTokenId, newRefreshTokenId, authzCodeRequest.getCode().getScopes(), authzCodeRequest.getClientInfo().getTokenExpiresIn());
    }

    public AccessTokenResponse issueToken(AccessTokenRefreshRequest refreshTokenRequest) {
        AccessTokenResponse generatedTokens = new AccessTokenValueGenerator().issueTokens();
        String newAccessTokenId = generatedTokens.getAccess_token();
        String newRefreshTokenId = generatedTokens.getRefresh_token();
        this.accessTokenAccessor.registerTokenFromRefreshToken(refreshTokenRequest, newAccessTokenId);
        this.refresTokenAccessor.registerTokenFromRefreshToken(refreshTokenRequest, newRefreshTokenId);
        return this.createTokenResponse(newAccessTokenId, newRefreshTokenId, refreshTokenRequest.getRefreshTokenInfo().getScopes(), refreshTokenRequest.getClientInfo().getTokenExpiresIn());
    }

    public AccessTokenResponse issueToken(AccessTokenSAMLBearerRequest samlBearerRequest) throws InternalErrorException {
        AccessTokenResponse generatedTokens = new AccessTokenValueGenerator().issueTokens();
        String newAccessTokenId = generatedTokens.getAccess_token();
        this.accessTokenAccessor.registerTokenFromSAMLBearer(samlBearerRequest, newAccessTokenId);
        return this.createTokenResponse(newAccessTokenId, null, samlBearerRequest.getScopes(), samlBearerRequest.getClientInfo().getTokenExpiresIn());
    }
}

