/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.token.refreshtoken;

import com.sap.cloud.security.oauth2.as.commons.scopes.ScopeInfo;
import java.util.HashSet;
import java.util.Set;

public class RefreshTokenInfo {
    private String refresh_token;
    private String originalRefreshToken;
    private String client_id = null;
    private String userId = null;
    private long issuedAt = 0L;
    private Set<ScopeInfo> scopes = new HashSet<ScopeInfo>();
    private String authzCodeId;
    private String previousRefreshToken;

    public String getRefreshToken() {
        return this.refresh_token;
    }

    public void setRefreshToken(String refresh_token) {
        this.refresh_token = refresh_token;
    }

    public String getOriginalRefreshToken() {
        return this.originalRefreshToken;
    }

    public void setOriginalRefreshToken(String originalRefreshToken) {
        this.originalRefreshToken = originalRefreshToken;
    }

    public String getClientId() {
        return this.client_id;
    }

    public void setClientId(String client_id) {
        this.client_id = client_id;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
    }

    public Set<ScopeInfo> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<ScopeInfo> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object obj) {
        if (this.refresh_token == null) {
            return false;
        }
        String obj_access_token = ((RefreshTokenInfo)obj).getRefreshToken();
        if (obj_access_token == null) {
            return false;
        }
        return this.refresh_token.equals(obj_access_token);
    }

    public int hashCode() {
        int result = 45;
        int c = 0;
        if (this.refresh_token != null) {
            c = this.refresh_token.hashCode();
        }
        result = 37 * result + c;
        return result;
    }

    public String getAuthzCodeId() {
        return this.authzCodeId;
    }

    public void setAuthzCodeId(String authzCodeId) {
        this.authzCodeId = authzCodeId;
    }

    public String getPreviousRefreshToken() {
        return this.previousRefreshToken;
    }

    public void setPreviousRefreshToken(String previousRefreshToken) {
        this.previousRefreshToken = previousRefreshToken;
    }

    public boolean containsAllScopes(String[] requestedScopes) {
        if (this.scopes == null) {
            return false;
        }
        String[] stringArray = requestedScopes;
        int n = requestedScopes.length;
        int n2 = 0;
        while (n2 < n) {
            String requestedScope = stringArray[n2];
            if (!this.scopeIsAssigned(requestedScope)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean scopeIsAssigned(String requestedScope) {
        for (ScopeInfo scope : this.scopes) {
            if (!requestedScope.equals(scope.getId())) continue;
            return true;
        }
        return false;
    }

    public Set<ScopeInfo> getAllScopesMatching(String[] requestedScopes) {
        HashSet<ScopeInfo> matchedScopes = new HashSet<ScopeInfo>();
        String[] stringArray = requestedScopes;
        int n = requestedScopes.length;
        int n2 = 0;
        while (n2 < n) {
            String requestedScope = stringArray[n2];
            for (ScopeInfo scope : this.scopes) {
                if (!requestedScope.equals(scope.getId())) continue;
                matchedScopes.add(scope);
            }
            ++n2;
        }
        return matchedScopes;
    }

    public String toString() {
        return "RefreshTokenInfo [refresh_token=" + this.refresh_token + ", orinalRefreshToken=" + this.originalRefreshToken + "client_id=" + this.client_id + ", userId=" + this.userId + ", issuedAt=" + this.issuedAt + ", scopes=" + this.scopes + ", authzCodeId=" + this.authzCodeId + "]";
    }
}

