/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.token.verify;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.exception.OAuthInvalidParameterException;
import com.sap.cloud.security.oauth2.as.commons.exception.OAuthUnauthorizeException;
import com.sap.cloud.security.oauth2.as.commons.utils.DateTimeUtils;
import com.sap.cloud.security.oauth2.commons.LoggerHelper;
import com.sap.cloud.security.oauth2.commons.token.AccessTokenInfo;

public class VerifyTokenEndpointValidator {
    public void validateRequestParameter(String accessTokenValues) throws OAuthInvalidParameterException {
        if (accessTokenValues == null || accessTokenValues.trim().equals("")) {
            throw new OAuthInvalidParameterException(ErrorCode.invalid_request, "access_token parameter is requiered and it must not be empty string.");
        }
    }

    public void validateAccessTokenExpiration(AccessTokenInfo token, int tokenExpiresInSec) throws OAuthUnauthorizeException {
        boolean isExpired = DateTimeUtils.isDateExpired(token.getIssuedat(), tokenExpiresInSec);
        if (isExpired) {
            String message = String.format("Access token [%s] has expired.", LoggerHelper.getTokenForLog((String)token.getAccessToken()));
            throw new OAuthUnauthorizeException(message);
        }
    }

    public void validateAccessToken(AccessTokenInfo token, String accessTokenId) throws OAuthUnauthorizeException {
        if (token == null) {
            String message = String.format("No access token with id [%s] found", LoggerHelper.getTokenForLog((String)accessTokenId));
            throw new OAuthUnauthorizeException(message);
        }
    }
}

