/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.utils;

import com.sap.cloud.security.oauth2.commons.logging.CommonLogger;
import com.sap.cloud.security.oauth2.commons.logging.CommonLoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;

public class RedirectURIsChecker {
    private static final CommonLogger logger = CommonLoggerFactory.getLogger(RedirectURIsChecker.class);
    private String clientRedirectURI;
    private String requestRedirectURI;

    public RedirectURIsChecker(String clientRedirectURI, String requestRedirectURI) {
        this.clientRedirectURI = clientRedirectURI;
        this.requestRedirectURI = requestRedirectURI;
    }

    public boolean isRequestAndClientRedirectURIsMatch() {
        if (this.clientRedirectURI == null || this.requestRedirectURI == null) {
            return false;
        }
        try {
            URI clientURI = new URI(this.clientRedirectURI);
            URI requestURI = new URI(this.requestRedirectURI);
            boolean schemesMatch = this.checkSchemes(clientURI.getScheme(), requestURI.getScheme());
            boolean hostsMatch = this.checkHosts(clientURI.getHost(), requestURI.getHost());
            boolean portsMatch = this.checkPorts(clientURI.getPort(), requestURI.getPort());
            boolean pathsMatch = this.checkPaths(clientURI.getPath(), requestURI.getPath());
            boolean queriesMatch = this.checkQuires(clientURI.getQuery(), requestURI.getQuery());
            return schemesMatch && hostsMatch && portsMatch && pathsMatch && queriesMatch;
        }
        catch (URISyntaxException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Problem while checking client redirect_uri: " + this.clientRedirectURI + " and request redirect_uri: " + this.requestRedirectURI, (Throwable)e);
            }
            return false;
        }
    }

    private boolean checkSchemes(String clientScheme, String requestScheme) {
        if (clientScheme == null || requestScheme == null) {
            return false;
        }
        return clientScheme.equals(requestScheme);
    }

    private boolean checkHosts(String clientHost, String requestHost) {
        if (clientHost == null || requestHost == null) {
            return false;
        }
        return requestHost.equals(clientHost);
    }

    private boolean checkPorts(int clientPort, int requestPort) {
        return clientPort == requestPort;
    }

    private boolean checkPaths(String clientPath, String requestPath) {
        if (clientPath == null || requestPath == null) {
            return false;
        }
        return requestPath.equals(clientPath) || requestPath.startsWith(String.valueOf(clientPath) + "/");
    }

    private boolean checkQuires(String clientQuery, String requestQuery) {
        if (this.isEmpty(clientQuery)) {
            return true;
        }
        if (clientQuery != null && requestQuery != null) {
            String[] clientParams = clientQuery.split("&");
            List<String> clientParamsList = Arrays.asList(clientParams);
            String[] requestParams = requestQuery.split("&");
            List<String> requestParamsList = Arrays.asList(requestParams);
            return requestParamsList.containsAll(clientParamsList);
        }
        return false;
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value.trim());
    }
}

