/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.utils;

import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;

public class URLBuilder {
    private static final String UTF_8 = "UTF-8";
    private String url;
    private Map<String, String> queryParams;

    public URLBuilder(String url, Map<String, String> queryParams) {
        this.url = url;
        this.queryParams = queryParams;
    }

    public URI build() throws InternalErrorException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> parameter : this.queryParams.entrySet()) {
            String encodedValue;
            String value;
            String string = value = parameter.getValue() == null ? null : String.valueOf(parameter.getValue());
            if (this.isEmpty(parameter.getKey()) || this.isEmpty(value)) continue;
            String encodedName = this.encode(parameter.getKey(), UTF_8);
            String string2 = encodedValue = value != null ? this.encode(value, UTF_8) : "";
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(encodedName);
            result.append("=");
            result.append(encodedValue);
        }
        StringBuilder location = new StringBuilder(this.url);
        boolean containsQuestionMark = this.url.contains("?");
        if (containsQuestionMark) {
            location.append("&").append((CharSequence)result);
        } else {
            location.append("?").append((CharSequence)result);
        }
        return this.getURI(location);
    }

    private URI getURI(StringBuilder location) throws InternalErrorException {
        try {
            return new URI(location.toString());
        }
        catch (URISyntaxException e) {
            throw new InternalErrorException(e.getMessage(), e);
        }
    }

    private String encode(String content, String encoding) throws InternalErrorException {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException(e.getMessage(), e);
        }
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }
}

