/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.as.commons.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class ValueGenerator {
    private static final String UTF_8 = "UTF-8";

    public static String generateMD5HashValue() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return ValueGenerator.generateMD5HashValue(UUID.randomUUID().toString());
    }

    public static String generateValue() {
        return ValueGenerator.generateValue(UUID.randomUUID().toString());
    }

    public static String generateValue(String param) {
        try {
            return UUID.fromString(UUID.nameUUIDFromBytes(param.getBytes(UTF_8)).toString()).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return ValueGenerator.generateValue();
        }
    }

    public static String generateMD5HashValue(String param) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest algorithm = MessageDigest.getInstance("MD5");
        algorithm.reset();
        algorithm.update(param.getBytes(UTF_8));
        byte[] messageDigest = algorithm.digest();
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < messageDigest.length) {
            hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
            ++i;
        }
        return hexString.toString();
    }
}

