/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.accessor.AccessorFactory;
import com.sap.cloud.security.oauth2.flow.Flow;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.impl.AuthorizationCodeFlow;
import com.sap.cloud.security.oauth2.flow.impl.ClientCredentialsFlow;
import com.sap.cloud.security.oauth2.flow.impl.RefreshTokenFlow;
import com.sap.cloud.security.oauth2.flow.impl.SAMLBearerFlow;
import com.sap.cloud.security.oauth2.flow.service.ScopeResolutionServiceFactory;

public class FlowFactory {
    private AccessorFactory accessorFactory;
    private ScopeResolutionServiceFactory scopeResolutionFactory;

    public FlowFactory(AccessorFactory accessorFactory, ScopeResolutionServiceFactory scopeResolutionFactory) {
        this.accessorFactory = accessorFactory;
        this.scopeResolutionFactory = scopeResolutionFactory;
    }

    public Flow createFlow(String grantType) {
        if ("client_credentials".equals(grantType)) {
            return new ClientCredentialsFlow(this.accessorFactory, this.scopeResolutionFactory);
        }
        if ("authorization_code".equals(grantType)) {
            return new AuthorizationCodeFlow(this.accessorFactory);
        }
        if ("refresh_token".equals(grantType)) {
            return new RefreshTokenFlow(this.accessorFactory);
        }
        if ("urn:ietf:params:oauth:grant-type:saml2-bearer".equals(grantType)) {
            return new SAMLBearerFlow(this.accessorFactory);
        }
        throw new UnsatisfiedFlowException("Unexpected request grant type.", ErrorCode.invalid_request);
    }
}

