/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.accessors;

import com.sap.cloud.security.oauth2.as.commons.code.AuthzCodeInfo;
import com.sap.cloud.security.oauth2.as.commons.code.IAuthzCodeAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.commons.client.IClientContext;
import java.util.HashMap;
import java.util.Map;

public class CacheableAuthzCodeAccessor
implements IAuthzCodeAccessor {
    private IAuthzCodeAccessor accessor;
    private Map<String, AuthzCodeInfo> cache;

    public CacheableAuthzCodeAccessor(IAuthzCodeAccessor accessor) {
        this.accessor = accessor;
        this.cache = new HashMap<String, AuthzCodeInfo>();
    }

    @Override
    public void registerAuthzCode(AuthzCodeInfo authzCode, IClientContext context) throws InternalErrorException, OAuthProblemException {
        throw new IllegalStateException("Registration of authorization code couldn't be cached.");
    }

    @Override
    public AuthzCodeInfo getAuthzCodeInfo(String code) throws InternalErrorException {
        AuthzCodeInfo authzCode = this.cache.get(code);
        if (authzCode == null) {
            authzCode = this.accessor.getAuthzCodeInfo(code);
            this.cache.put(code, authzCode);
        }
        return authzCode;
    }

    @Override
    public void deleteAuthzCode(AuthzCodeInfo authzCode) throws OAuthProblemException, InternalErrorException {
        this.accessor.deleteAuthzCode(authzCode);
    }
}

