/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.accessors;

import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.client.InternationalizedClientInfo;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.as.commons.scopes.ScopeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheableClientStorageAccessor
implements IClientAccessor {
    private IClientAccessor accessor;
    private Map<String, BasicClientInfo> cache;
    private Map<String, InternationalizedClientInfo> internationalCache;

    public CacheableClientStorageAccessor(IClientAccessor accessor) {
        this.accessor = accessor;
        this.cache = new HashMap<String, BasicClientInfo>();
        this.internationalCache = new HashMap<String, InternationalizedClientInfo>();
    }

    @Override
    public Set<String> getClientIDs() {
        throw new IllegalStateException("Getting all application clients IDs is not implemented.");
    }

    @Override
    public long getClientCount() {
        throw new IllegalStateException("Getting all clients count is not implemented.");
    }

    @Override
    public long getClientCount(String account) {
        throw new IllegalStateException("Getting clients count for given account is not implemented.");
    }

    @Override
    public List<BasicClientInfo> getClients() throws InternalErrorException {
        throw new IllegalStateException("Getting all clients is not implemented");
    }

    @Override
    public List<BasicClientInfo> getClients(int page, int pageSize) throws InternalErrorException {
        throw new IllegalStateException("Getting all clients in a given range is not implemented.");
    }

    @Override
    public InternationalizedClientInfo getInternationalizedClientByID(String clientId, String language) throws InternalErrorException {
        InternationalizedClientInfo client = this.internationalCache.get(clientId);
        if (client == null) {
            client = this.accessor.getInternationalizedClientByID(clientId, language);
            this.internationalCache.put(clientId, client);
        }
        return client;
    }

    @Override
    public Map<String, ScopeInfo> getScopes(BasicClientInfo basicClientInfo) throws InternalErrorException, OAuthProblemException {
        throw new IllegalStateException("Getting client scopes by given client is not implemented.");
    }

    @Override
    public boolean checkSecret(String secretToCheck, String clientId) throws InternalErrorException {
        return this.accessor.checkSecret(secretToCheck, clientId);
    }

    @Override
    public BasicClientInfo getBasicClientById(String clientId) throws InternalErrorException {
        BasicClientInfo client = this.cache.get(clientId);
        if (client == null) {
            client = this.accessor.getBasicClientById(clientId);
            this.cache.put(clientId, client);
        }
        return client;
    }
}

