/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.accessors;

import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenAuthzCodeRequest;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenRefreshRequest;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.IRefreshTokenAccessor;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.RefreshTokenInfo;
import java.util.HashMap;
import java.util.Map;

public class CacheableRefreshTokenAccessor
implements IRefreshTokenAccessor {
    private IRefreshTokenAccessor accessor;
    private Map<String, RefreshTokenInfo> cache;

    public CacheableRefreshTokenAccessor(IRefreshTokenAccessor accessor) {
        this.accessor = accessor;
        this.cache = new HashMap<String, RefreshTokenInfo>();
    }

    @Override
    public RefreshTokenInfo getToken(String token) throws OAuthProblemException, InternalErrorException {
        RefreshTokenInfo refreshToken = this.cache.get(token);
        if (refreshToken == null) {
            refreshToken = this.accessor.getToken(token);
            this.cache.put(token, refreshToken);
        }
        return refreshToken;
    }

    @Override
    public void deleteToken(RefreshTokenInfo tokenInfo) throws InternalErrorException {
        throw new IllegalStateException("Deleting token by instance is not implemented.");
    }

    @Override
    public void registerAuthzCodeToken(AccessTokenAuthzCodeRequest authzCodeRequest, String newRefreshTokenId) throws InternalErrorException {
        throw new IllegalStateException("Registering authorization token is not implemented.");
    }

    @Override
    public void registerTokenFromRefreshToken(AccessTokenRefreshRequest refreshRequest, String newRefreshTokenId) throws InternalErrorException {
        throw new IllegalStateException("Registering token from refresh token is not implemented.");
    }
}

