/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.attributes;

import com.sap.cloud.security.oauth2.commons.LoggerHelper;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderService;
import com.sap.cloud.security.oauth2.flow.service.CacheableAuthorizationHeaderService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAttributes {
    private static final String REFRESH_TOKEN_PARAM = "refresh_token";
    private static final String ASSERTION_PARAM = "assertion";
    private static final String REDIRECT_URI_PARAM = "redirect_uri";
    private static final String AUTORIZATION_CODE_PARAM = "code";
    private static final String GRANT_TYPE_PARAM = "grant_type";
    private static final String SCOPE_PARAM = "scope";
    private static final String CLIENT_ID_PARAM = "client_id";
    private static final String TRACE_DELIMITER = ", ";
    private HttpServletRequest request;
    private Map<String, List<String>> requestParams;
    private AuthorizationHeaderService authorizationService;
    private static final Logger logger = LoggerFactory.getLogger(RequestAttributes.class);

    public RequestAttributes(HttpServletRequest request, Map<String, List<String>> requestParams) {
        this.request = request;
        this.requestParams = requestParams;
        this.authorizationService = new CacheableAuthorizationHeaderService();
    }

    public String getAuthorizationHeader() {
        return this.request.getHeader("Authorization");
    }

    public String getClientIdFromAuthorizationHeader() {
        return this.authorizationService.extractUsernameFrom(this.getAuthorizationHeader());
    }

    public String getClientId() {
        return this.getParameter(CLIENT_ID_PARAM);
    }

    public String[] getClientIdParameters() {
        return this.getParameters(CLIENT_ID_PARAM);
    }

    public String getScopes() {
        return this.getParameter(SCOPE_PARAM);
    }

    public String[] getScopeParameters() {
        return this.getParameters(SCOPE_PARAM);
    }

    public String[] getScopesAsArray() {
        String scopes = this.getScopes();
        if (scopes == null) {
            return new String[0];
        }
        return scopes.contains(" ") ? scopes.split(" ") : scopes.split(",");
    }

    public String getGrantType() {
        return this.getParameter(GRANT_TYPE_PARAM);
    }

    public String[] getGrantTypeParameters() {
        return this.getParameters(GRANT_TYPE_PARAM);
    }

    public String getAuthorizationCode() {
        return this.getParameter(AUTORIZATION_CODE_PARAM);
    }

    public String[] getAuthorizationCodeParameters() {
        return this.getParameters(AUTORIZATION_CODE_PARAM);
    }

    public String getRedirectURI() {
        return this.getParameter(REDIRECT_URI_PARAM);
    }

    public String[] getRedirectURIParameters() {
        return this.getParameters(REDIRECT_URI_PARAM);
    }

    public String getAssertion() {
        return this.getParameter(ASSERTION_PARAM);
    }

    public String[] getAssertionParameters() {
        return this.getParameters(ASSERTION_PARAM);
    }

    public String getRefreshToken() {
        return this.getParameter(REFRESH_TOKEN_PARAM);
    }

    public String[] getRefreshTokenParameters() {
        return this.getParameters(REFRESH_TOKEN_PARAM);
    }

    private String getParameter(String param) {
        List<String> list = this.requestParams.get(param);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    private String[] getParameters(String param) {
        List<String> list = this.requestParams.get(param);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[0]);
    }

    public boolean isPlatformTokenIssuingRequest() {
        String requestURI = this.request.getRequestURI();
        return requestURI != null && requestURI.contains("apitoken");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.constructForLog(CLIENT_ID_PARAM, this.getClientIdForLog()));
        builder.append(this.constructForLog(GRANT_TYPE_PARAM, this.getGrantType()));
        builder.append(this.constructForLog(SCOPE_PARAM, this.getScopes()));
        builder.append(this.constructForLog(REDIRECT_URI_PARAM, this.getRedirectURI()));
        builder.append(this.constructForLog(ASSERTION_PARAM, this.getAssertion()));
        builder.append(this.constructForSecuredLog(AUTORIZATION_CODE_PARAM, this.getAuthorizationCode()));
        builder.append(this.constructForSecuredLog(REFRESH_TOKEN_PARAM, this.getRefreshToken()));
        if (builder.lastIndexOf(TRACE_DELIMITER) > 0) {
            builder = builder.delete(builder.lastIndexOf(TRACE_DELIMITER), builder.length());
        }
        return "Input parameters: [" + builder + "]";
    }

    private String getClientIdForLog() {
        String clientId = null;
        try {
            clientId = this.getClientIdFromAuthorizationHeader();
        }
        catch (RuntimeException exp) {
            logger.trace("There is exception thrown during getting the client id from the authorization header.", (Throwable)exp);
            return this.getClientId();
        }
        return clientId == null ? this.getClientId() : clientId;
    }

    protected String constructForLog(String paramName, String paramValue) {
        return paramValue != null ? String.valueOf(paramName) + "=" + paramValue + TRACE_DELIMITER : "";
    }

    protected String constructForSecuredLog(String paramName, String paramValue) {
        return paramValue != null ? String.valueOf(paramName) + "=" + LoggerHelper.getTokenForLog((String)paramValue) + TRACE_DELIMITER : "";
    }
}

