/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.impl;

import com.sap.cloud.security.oauth2.as.commons.accessor.AccessorFactory;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.code.AuthzCodeInfo;
import com.sap.cloud.security.oauth2.as.commons.code.IAuthzCodeAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenResponse;
import com.sap.cloud.security.oauth2.flow.Flow;
import com.sap.cloud.security.oauth2.flow.accessors.CacheableAuthzCodeAccessor;
import com.sap.cloud.security.oauth2.flow.accessors.CacheableClientStorageAccessor;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.issuers.AuthorizationCodeTokenIssuingService;
import com.sap.cloud.security.oauth2.flow.issuers.TokenIssuingService;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.code.AuthorizationCodeExistence;
import com.sap.cloud.security.oauth2.flow.requirements.code.AuthorizationCodeOwnerMatch;
import com.sap.cloud.security.oauth2.flow.requirements.code.AuthorizationCodePresence;
import com.sap.cloud.security.oauth2.flow.requirements.code.AuthorizationCodeValidity;
import com.sap.cloud.security.oauth2.flow.requirements.code.RedirectURIValidity;
import com.sap.cloud.security.oauth2.flow.requirements.common.AndCompositeRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.ClientExistence;
import com.sap.cloud.security.oauth2.flow.requirements.common.ClientIdPresence;
import com.sap.cloud.security.oauth2.flow.requirements.common.PublicClient;
import com.sap.cloud.security.oauth2.flow.requirements.common.TernaryConditionalRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.ValidClientCredentials;
import com.sap.cloud.security.oauth2.flow.requirements.condition.AuthorizationHeaderPresenceCondition;
import com.sap.cloud.security.oauth2.flow.requirements.condition.ConfidentialClientCondition;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderClientIdProvider;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderService;
import com.sap.cloud.security.oauth2.flow.service.CacheableAuthorizationHeaderService;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import com.sap.cloud.security.oauth2.flow.service.ParameterClientIdProvider;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationCodeFlow
implements Flow {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationCodeFlow.class);
    private IAuthzCodeAccessor authzCodeAccessor;
    private AuthorizationHeaderService authorizationService;
    private IClientAccessor clientAccessor;
    private ClientIdProvider parameterClientIdProvider;
    private ClientIdProvider authorizationHeaderClientIdProvider;
    private AccessTokenResponse issuedToken;
    private AccessorFactory accessorFactory;

    public AuthorizationCodeFlow(AccessorFactory accessorFactory) {
        this.accessorFactory = accessorFactory;
        this.clientAccessor = this.createClientAccessor();
        this.authzCodeAccessor = this.createAuthorizationCodeAccessor();
        this.authorizationService = this.createAuthorizationService();
        this.parameterClientIdProvider = this.createParameterClientIdProvider();
        this.authorizationHeaderClientIdProvider = this.createAuthorizationHeaderClientIdProvider();
    }

    protected IClientAccessor createClientAccessor() {
        return new CacheableClientStorageAccessor(this.accessorFactory.getClientAccessor());
    }

    protected IAuthzCodeAccessor createAuthorizationCodeAccessor() {
        return new CacheableAuthzCodeAccessor(this.accessorFactory.getCodeAccessor());
    }

    AuthorizationHeaderService createAuthorizationService() {
        return new CacheableAuthorizationHeaderService();
    }

    ParameterClientIdProvider createParameterClientIdProvider() {
        return new ParameterClientIdProvider();
    }

    ClientIdProvider createAuthorizationHeaderClientIdProvider() {
        return new AuthorizationHeaderClientIdProvider();
    }

    @Override
    public void validate(RequestAttributes attributes) {
        ArrayList<FlowRequirement> requirements = new ArrayList<FlowRequirement>();
        requirements.add(new AuthorizationCodePresence());
        requirements.add(new RedirectURIValidity(this.authzCodeAccessor));
        requirements.add(new TernaryConditionalRequirement(new AuthorizationHeaderPresenceCondition(), new TernaryConditionalRequirement(new ConfidentialClientCondition(this.clientAccessor), new AndCompositeRequirement(new ClientExistence(this.clientAccessor, this.authorizationHeaderClientIdProvider), new ValidClientCredentials(this.clientAccessor, this.authorizationService)), new ClientExistence(this.clientAccessor, this.authorizationHeaderClientIdProvider)), new AndCompositeRequirement(new ClientIdPresence(), new PublicClient(this.clientAccessor), new ClientExistence(this.clientAccessor, this.parameterClientIdProvider))));
        requirements.add(new AuthorizationCodeExistence(this.authzCodeAccessor));
        requirements.add(new TernaryConditionalRequirement(new AuthorizationHeaderPresenceCondition(), new AuthorizationCodeOwnerMatch(this.authzCodeAccessor, this.authorizationHeaderClientIdProvider), new AuthorizationCodeOwnerMatch(this.authzCodeAccessor, this.parameterClientIdProvider)));
        requirements.add(new TernaryConditionalRequirement(new AuthorizationHeaderPresenceCondition(), new AuthorizationCodeValidity(this.authzCodeAccessor, this.clientAccessor, this.authorizationHeaderClientIdProvider), new AuthorizationCodeValidity(this.authzCodeAccessor, this.clientAccessor, this.parameterClientIdProvider)));
        logger.debug("Validating authorization code request. Request attributes: [{}]. Flow requirements: [{}]", (Object)attributes, requirements);
        for (FlowRequirement requirement : requirements) {
            requirement.fulfilledBy(attributes);
        }
    }

    @Override
    public void process(RequestAttributes attributes) {
        TokenIssuingService tokenIssuingService = this.createTokenIssuingService(attributes);
        this.issuedToken = tokenIssuingService.issueToken(attributes);
        logger.debug("Access token was successfully issued.");
        this.deleteAuthorizationCode(attributes.getAuthorizationCode());
    }

    TokenIssuingService createTokenIssuingService(RequestAttributes attributes) {
        if (this.isRequestWithAuthorizationHeader(attributes)) {
            return new AuthorizationCodeTokenIssuingService(this.accessorFactory, this.authorizationHeaderClientIdProvider);
        }
        return new AuthorizationCodeTokenIssuingService(this.accessorFactory, this.parameterClientIdProvider);
    }

    private boolean isRequestWithAuthorizationHeader(RequestAttributes attributes) {
        return attributes.getAuthorizationHeader() != null;
    }

    void deleteAuthorizationCode(String authorizationCode) {
        logger.debug("Deleting authorization code.");
        AuthzCodeInfo authzCode = this.authzCodeAccessor.getAuthzCodeInfo(authorizationCode);
        try {
            this.authzCodeAccessor.deleteAuthzCode(authzCode);
        }
        catch (OAuthProblemException exception) {
            throw new UnexpectedFlowException("Failed to delete authorization code.", exception);
        }
        logger.debug("Authorization code was successfully deleted.");
    }

    @Override
    public AccessTokenResponse getResult() {
        return this.issuedToken;
    }
}

