/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.impl;

import com.sap.cloud.security.oauth2.as.commons.accessor.AccessorFactory;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenResponse;
import com.sap.cloud.security.oauth2.flow.Flow;
import com.sap.cloud.security.oauth2.flow.accessors.CacheableClientStorageAccessor;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.issuers.ClientCredentialsTokenIssuingService;
import com.sap.cloud.security.oauth2.flow.issuers.TokenIssuingService;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.AuthorizationHeaderPresence;
import com.sap.cloud.security.oauth2.flow.requirements.common.ClientConfidentiality;
import com.sap.cloud.security.oauth2.flow.requirements.common.ClientExistence;
import com.sap.cloud.security.oauth2.flow.requirements.common.PlatformScopesExistence;
import com.sap.cloud.security.oauth2.flow.requirements.common.ScopesExistence;
import com.sap.cloud.security.oauth2.flow.requirements.common.ScopesParamPresence;
import com.sap.cloud.security.oauth2.flow.requirements.common.TernaryConditionalRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.ValidClientCredentials;
import com.sap.cloud.security.oauth2.flow.requirements.condition.PlatformTokenIssuingRequestCondition;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderClientIdProvider;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderService;
import com.sap.cloud.security.oauth2.flow.service.CacheableAuthorizationHeaderService;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import com.sap.cloud.security.oauth2.flow.service.ScopeResolutionServiceFactory;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialsFlow
implements Flow {
    private static final Logger logger = LoggerFactory.getLogger(ClientCredentialsFlow.class);
    private IClientAccessor clientAccessor;
    private ClientIdProvider clientIdProvider;
    private AuthorizationHeaderService authorizationService;
    private AccessTokenResponse issuedToken;
    private ScopeResolutionServiceFactory scopeResolutionServiceFactory;
    private AccessorFactory accessorFactory;

    public ClientCredentialsFlow(AccessorFactory accessorFactory, ScopeResolutionServiceFactory scopeResolutionServiceFactory) {
        this.accessorFactory = accessorFactory;
        this.scopeResolutionServiceFactory = scopeResolutionServiceFactory;
        this.clientAccessor = this.createClientAccessor();
        this.clientIdProvider = this.createClientIdProvider();
        this.authorizationService = this.createAuthorizationheaderService();
    }

    protected IClientAccessor createClientAccessor() {
        return new CacheableClientStorageAccessor(this.accessorFactory.getClientAccessor());
    }

    ClientIdProvider createClientIdProvider() {
        return new AuthorizationHeaderClientIdProvider();
    }

    AuthorizationHeaderService createAuthorizationheaderService() {
        return new CacheableAuthorizationHeaderService();
    }

    @Override
    public void validate(RequestAttributes attributes) {
        ArrayList<FlowRequirement> requirements = new ArrayList<FlowRequirement>();
        requirements.add(new AuthorizationHeaderPresence(this.authorizationService));
        requirements.add(new ScopesParamPresence());
        requirements.add(new ClientExistence(this.clientAccessor, this.clientIdProvider));
        requirements.add(new ClientConfidentiality(this.clientAccessor));
        requirements.add(new ValidClientCredentials(this.clientAccessor, this.authorizationService));
        requirements.add(new TernaryConditionalRequirement(new PlatformTokenIssuingRequestCondition(), new PlatformScopesExistence(this.clientAccessor), new ScopesExistence(this.clientAccessor)));
        logger.debug("Validating client credentials request. Request attributes: [{}]. Flow requirements: [{}]", (Object)attributes, requirements);
        for (FlowRequirement requirement : requirements) {
            requirement.fulfilledBy(attributes);
        }
    }

    @Override
    public void process(RequestAttributes attributes) {
        TokenIssuingService tokenIssuingService = this.createTokenIssuingService();
        this.issuedToken = tokenIssuingService.issueToken(attributes);
        logger.debug("Access token was successfully issued.");
    }

    protected TokenIssuingService createTokenIssuingService() {
        return new ClientCredentialsTokenIssuingService(this.accessorFactory, this.scopeResolutionServiceFactory);
    }

    @Override
    public AccessTokenResponse getResult() {
        return this.issuedToken;
    }
}

