/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.impl;

import com.sap.cloud.security.oauth2.as.commons.accessor.AccessorFactory;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenResponse;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.IRefreshTokenAccessor;
import com.sap.cloud.security.oauth2.flow.Flow;
import com.sap.cloud.security.oauth2.flow.accessors.CacheableClientStorageAccessor;
import com.sap.cloud.security.oauth2.flow.accessors.CacheableRefreshTokenAccessor;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.issuers.RefreshTokenIssuingService;
import com.sap.cloud.security.oauth2.flow.issuers.TokenIssuingService;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.AndCompositeRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.ClientExistence;
import com.sap.cloud.security.oauth2.flow.requirements.common.ClientIdPresence;
import com.sap.cloud.security.oauth2.flow.requirements.common.ConditionalRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.PublicClient;
import com.sap.cloud.security.oauth2.flow.requirements.common.ScopesParamPresence;
import com.sap.cloud.security.oauth2.flow.requirements.common.TernaryConditionalRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.ValidClientCredentials;
import com.sap.cloud.security.oauth2.flow.requirements.condition.AuthorizationHeaderPresenceCondition;
import com.sap.cloud.security.oauth2.flow.requirements.condition.ConfidentialClientCondition;
import com.sap.cloud.security.oauth2.flow.requirements.condition.ScopesParamPresenceCondition;
import com.sap.cloud.security.oauth2.flow.requirements.refresh.RefreshTokenExistence;
import com.sap.cloud.security.oauth2.flow.requirements.refresh.RefreshTokenOwnerMatch;
import com.sap.cloud.security.oauth2.flow.requirements.refresh.RefreshTokenParameterPresence;
import com.sap.cloud.security.oauth2.flow.requirements.refresh.RefreshTokenScopesExistence;
import com.sap.cloud.security.oauth2.flow.requirements.refresh.RefreshTokenValidity;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderClientIdProvider;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderService;
import com.sap.cloud.security.oauth2.flow.service.CacheableAuthorizationHeaderService;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import com.sap.cloud.security.oauth2.flow.service.ParameterClientIdProvider;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenFlow
implements Flow {
    private static final Logger logger = LoggerFactory.getLogger(RefreshTokenFlow.class);
    private IRefreshTokenAccessor refreshTokenAccessor;
    private AuthorizationHeaderService authorizationService;
    private IClientAccessor clientAccessor;
    private ClientIdProvider parameterClientIdProvider;
    private ClientIdProvider authorizationHeaderClientIdProvider;
    private AccessTokenResponse issuedToken;
    private AccessorFactory accessorFactory;

    public RefreshTokenFlow(AccessorFactory accessorFactory) {
        this.accessorFactory = accessorFactory;
        this.clientAccessor = this.createClientAccessor();
        this.refreshTokenAccessor = this.createRefreshTokenAccessor();
        this.authorizationService = this.createAuthorizationHeaderService();
        this.parameterClientIdProvider = this.createParameterClientIdProvider();
        this.authorizationHeaderClientIdProvider = this.createAuthorizationHeaderClientIdProvider();
    }

    protected IClientAccessor createClientAccessor() {
        return new CacheableClientStorageAccessor(this.accessorFactory.getClientAccessor());
    }

    protected IRefreshTokenAccessor createRefreshTokenAccessor() {
        return new CacheableRefreshTokenAccessor(this.accessorFactory.getRefreshTokenAccessor());
    }

    AuthorizationHeaderService createAuthorizationHeaderService() {
        return new CacheableAuthorizationHeaderService();
    }

    ClientIdProvider createParameterClientIdProvider() {
        return new ParameterClientIdProvider();
    }

    ClientIdProvider createAuthorizationHeaderClientIdProvider() {
        return new AuthorizationHeaderClientIdProvider();
    }

    @Override
    public void validate(RequestAttributes attributes) {
        ArrayList<FlowRequirement> requirements = new ArrayList<FlowRequirement>();
        requirements.add(new RefreshTokenParameterPresence());
        requirements.add(new TernaryConditionalRequirement(new AuthorizationHeaderPresenceCondition(), new TernaryConditionalRequirement(new ConfidentialClientCondition(this.clientAccessor), new AndCompositeRequirement(new ClientExistence(this.clientAccessor, this.authorizationHeaderClientIdProvider), new ValidClientCredentials(this.clientAccessor, this.authorizationService)), new ClientExistence(this.clientAccessor, this.authorizationHeaderClientIdProvider)), new AndCompositeRequirement(new ClientIdPresence(), new ClientExistence(this.clientAccessor, this.parameterClientIdProvider), new PublicClient(this.clientAccessor))));
        requirements.add(new RefreshTokenExistence(this.refreshTokenAccessor));
        requirements.add(new ConditionalRequirement(new ScopesParamPresenceCondition(), new AndCompositeRequirement(new ScopesParamPresence(), new RefreshTokenScopesExistence(this.refreshTokenAccessor))));
        requirements.add(new TernaryConditionalRequirement(new AuthorizationHeaderPresenceCondition(), new RefreshTokenValidity(this.refreshTokenAccessor, this.clientAccessor, this.authorizationHeaderClientIdProvider), new RefreshTokenValidity(this.refreshTokenAccessor, this.clientAccessor, this.parameterClientIdProvider)));
        requirements.add(new TernaryConditionalRequirement(new AuthorizationHeaderPresenceCondition(), new RefreshTokenOwnerMatch(this.refreshTokenAccessor, this.clientAccessor, this.authorizationHeaderClientIdProvider), new RefreshTokenOwnerMatch(this.refreshTokenAccessor, this.clientAccessor, this.parameterClientIdProvider)));
        logger.debug("Validating refresh token request. Request attributes: [{}]. Flow requirements: [{}]", (Object)attributes, requirements);
        for (FlowRequirement requirement : requirements) {
            requirement.fulfilledBy(attributes);
        }
    }

    @Override
    public void process(RequestAttributes attributes) {
        TokenIssuingService tokenIssuingService = this.createTokenIssuingService(attributes);
        this.issuedToken = tokenIssuingService.issueToken(attributes);
        logger.debug("Access token was successfully issued.");
    }

    protected TokenIssuingService createTokenIssuingService(RequestAttributes attributes) {
        if (this.isRequestWithAuthorizationHeader(attributes)) {
            return new RefreshTokenIssuingService(this.accessorFactory, this.authorizationHeaderClientIdProvider);
        }
        return new RefreshTokenIssuingService(this.accessorFactory, this.parameterClientIdProvider);
    }

    private boolean isRequestWithAuthorizationHeader(RequestAttributes attributes) {
        return attributes.getAuthorizationHeader() != null;
    }

    @Override
    public AccessTokenResponse getResult() {
        return this.issuedToken;
    }
}

