/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.impl;

import com.sap.cloud.security.oauth2.as.commons.accessor.AccessorFactory;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.saml.SAMLConfigurationAccessor;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenResponse;
import com.sap.cloud.security.oauth2.flow.Flow;
import com.sap.cloud.security.oauth2.flow.accessors.CacheableClientStorageAccessor;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.issuers.SAMLBearerTokenIssuingService;
import com.sap.cloud.security.oauth2.flow.issuers.TokenIssuingService;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.AndCompositeRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.ClientExistence;
import com.sap.cloud.security.oauth2.flow.requirements.common.ClientIdPresence;
import com.sap.cloud.security.oauth2.flow.requirements.common.PublicClient;
import com.sap.cloud.security.oauth2.flow.requirements.common.TernaryConditionalRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.common.ValidClientCredentials;
import com.sap.cloud.security.oauth2.flow.requirements.condition.AuthorizationHeaderPresenceCondition;
import com.sap.cloud.security.oauth2.flow.requirements.condition.ConfidentialClientCondition;
import com.sap.cloud.security.oauth2.flow.requirements.saml.AssertionParameterPresence;
import com.sap.cloud.security.oauth2.flow.requirements.saml.ValidAssertion;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderClientIdProvider;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderService;
import com.sap.cloud.security.oauth2.flow.service.CacheableAuthorizationHeaderService;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import com.sap.cloud.security.oauth2.flow.service.ParameterClientIdProvider;
import com.sap.cloud.security.oauth2.flow.service.SAMLService;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLBearerFlow
implements Flow {
    private static final Logger logger = LoggerFactory.getLogger(SAMLBearerFlow.class);
    private SAMLService samlService;
    private IClientAccessor clientAccessor;
    private AuthorizationHeaderService authorizationService;
    private ClientIdProvider parameterClientIdProvider;
    private ClientIdProvider authorizationHeaderClientIdProvider;
    private AccessTokenResponse issuedToken;
    private AccessorFactory accessorFactory;

    public SAMLBearerFlow(AccessorFactory accessorFactory) {
        this.accessorFactory = accessorFactory;
        this.samlService = this.createSAMLService();
        this.clientAccessor = this.createClientAccessor();
        this.authorizationService = this.createAuthorizationHeaderService();
        this.parameterClientIdProvider = this.createParameterClientIdProvider();
        this.authorizationHeaderClientIdProvider = this.createAuthorizationHeaderClientIdProvider();
    }

    IClientAccessor createClientAccessor() {
        return new CacheableClientStorageAccessor(this.accessorFactory.getClientAccessor());
    }

    ParameterClientIdProvider createParameterClientIdProvider() {
        return new ParameterClientIdProvider();
    }

    ClientIdProvider createAuthorizationHeaderClientIdProvider() {
        return new AuthorizationHeaderClientIdProvider();
    }

    AuthorizationHeaderService createAuthorizationHeaderService() {
        return new CacheableAuthorizationHeaderService();
    }

    SAMLService createSAMLService() {
        return new SAMLService(new SAMLConfigurationAccessor());
    }

    @Override
    public void validate(RequestAttributes attributes) {
        ArrayList<FlowRequirement> requirements = new ArrayList<FlowRequirement>();
        requirements.add(new AssertionParameterPresence());
        requirements.add(new TernaryConditionalRequirement(new AuthorizationHeaderPresenceCondition(), new TernaryConditionalRequirement(new ConfidentialClientCondition(this.clientAccessor), new AndCompositeRequirement(new ClientExistence(this.clientAccessor, this.authorizationHeaderClientIdProvider), new ValidClientCredentials(this.clientAccessor, this.authorizationService)), new ClientExistence(this.clientAccessor, this.authorizationHeaderClientIdProvider)), new AndCompositeRequirement(new ClientIdPresence(), new PublicClient(this.clientAccessor), new ClientExistence(this.clientAccessor, this.parameterClientIdProvider))));
        requirements.add(new ValidAssertion(this.samlService));
        logger.debug("Validating SAML bearer request. Request attributes: [{}]. Flow requirements: [{}]", (Object)attributes, requirements);
        for (FlowRequirement requirement : requirements) {
            requirement.fulfilledBy(attributes);
        }
    }

    @Override
    public void process(RequestAttributes attributes) {
        TokenIssuingService tokenIssuingService = this.createTokenIssuingService(attributes);
        this.issuedToken = tokenIssuingService.issueToken(attributes);
        logger.debug("Access token was successfully issued.");
    }

    TokenIssuingService createTokenIssuingService(RequestAttributes attributes) {
        if (this.isRequestWithAuthorizationHeader(attributes)) {
            return new SAMLBearerTokenIssuingService(this.accessorFactory, this.samlService, this.authorizationHeaderClientIdProvider);
        }
        return new SAMLBearerTokenIssuingService(this.accessorFactory, this.samlService, this.parameterClientIdProvider);
    }

    private boolean isRequestWithAuthorizationHeader(RequestAttributes attributes) {
        return attributes.getAuthorizationHeader() != null;
    }

    @Override
    public AccessTokenResponse getResult() {
        return this.issuedToken;
    }
}

