/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.issuers;

import com.sap.cloud.security.oauth2.as.commons.accessor.AccessorFactory;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.client.InternationalizedClientInfo;
import com.sap.cloud.security.oauth2.as.commons.code.AuthzCodeInfo;
import com.sap.cloud.security.oauth2.as.commons.code.IAuthzCodeAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenAuthzCodeRequest;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenIssuer;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenResponse;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.issuers.TokenIssuingService;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationCodeTokenIssuingService
implements TokenIssuingService {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationCodeTokenIssuingService.class);
    private AccessTokenIssuer tokenIssuer;
    private IAuthzCodeAccessor authzCodeAccessor;
    private IClientAccessor clientAccessor;
    private ClientIdProvider clientIdProvider;

    public AuthorizationCodeTokenIssuingService(AccessorFactory accessorFactory, ClientIdProvider clientIdProvider) {
        this.tokenIssuer = new AccessTokenIssuer(accessorFactory.getAccessTokenAccessor(), accessorFactory.getRefreshTokenAccessor());
        this.authzCodeAccessor = accessorFactory.getCodeAccessor();
        this.clientAccessor = accessorFactory.getClientAccessor();
        this.clientIdProvider = clientIdProvider;
    }

    @Override
    public AccessTokenResponse issueToken(RequestAttributes attributes) {
        logger.debug("Issuing access token for authorization code flow.");
        InternationalizedClientInfo clientInfo = this.retreiveClient(this.clientIdProvider.getClientIdFrom(attributes));
        AuthzCodeInfo codeInfo = this.retrieveAuthorizationCode(attributes.getAuthorizationCode());
        try {
            return this.tokenIssuer.issueToken(new AccessTokenAuthzCodeRequest(codeInfo, clientInfo.getRedirectUri(), clientInfo));
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to issue token.", exception);
        }
    }

    private InternationalizedClientInfo retreiveClient(String clientId) {
        try {
            return this.clientAccessor.getInternationalizedClientByID(clientId, null);
        }
        catch (InternalErrorException exception) {
            logger.error("Failed to retreive client by given id.", (Throwable)exception);
            throw new UnexpectedFlowException("Failed to retreive client by id", exception);
        }
    }

    private AuthzCodeInfo retrieveAuthorizationCode(String authorizationCode) {
        try {
            return this.authzCodeAccessor.getAuthzCodeInfo(authorizationCode);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive authorization code by given identifier", exception);
        }
    }
}

