/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.issuers;

import com.sap.cloud.security.oauth2.as.commons.accessor.AccessorFactory;
import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.scopes.ScopeInfo;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenCCRequest;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenIssuer;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenResponse;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.issuers.TokenIssuingService;
import com.sap.cloud.security.oauth2.flow.service.ScopeResolutionService;
import com.sap.cloud.security.oauth2.flow.service.ScopeResolutionServiceFactory;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialsTokenIssuingService
implements TokenIssuingService {
    private static final Logger logger = LoggerFactory.getLogger(ClientCredentialsTokenIssuingService.class);
    private AccessTokenIssuer tokenIssuer;
    private IClientAccessor clientAccessor;
    private ScopeResolutionServiceFactory scopeResolutionServiceFactory;

    public ClientCredentialsTokenIssuingService(AccessorFactory accessorFactory, ScopeResolutionServiceFactory scopeResolutionServiceFactory) {
        this.tokenIssuer = this.createTokenIssuer(accessorFactory);
        this.clientAccessor = accessorFactory.getClientAccessor();
        this.scopeResolutionServiceFactory = scopeResolutionServiceFactory;
    }

    AccessTokenIssuer createTokenIssuer(AccessorFactory accessorFactory) {
        return new AccessTokenIssuer(accessorFactory.getAccessTokenAccessor(), accessorFactory.getRefreshTokenAccessor());
    }

    @Override
    public AccessTokenResponse issueToken(RequestAttributes attributes) {
        logger.debug("Issuing access token for client credentials flow.");
        BasicClientInfo client = this.retreiveClient(attributes.getClientIdFromAuthorizationHeader());
        String[] requestedScopes = attributes.getScopesAsArray();
        ScopeResolutionService scopeResolutionService = this.scopeResolutionServiceFactory.createService(client);
        Set<ScopeInfo> scopes = scopeResolutionService.toScopes(requestedScopes);
        try {
            return this.tokenIssuer.issueToken(new AccessTokenCCRequest(scopes, client));
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to issue token.", exception);
        }
    }

    BasicClientInfo retreiveClient(String clientId) {
        try {
            return this.clientAccessor.getBasicClientById(clientId);
        }
        catch (InternalErrorException exception) {
            logger.error("Failed to retreive client by given id.", (Throwable)exception);
            throw new UnexpectedFlowException("Failed to retreive client by given id.", exception);
        }
    }
}

