/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.issuers;

import com.sap.cloud.security.oauth2.as.commons.accessor.AccessorFactory;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.client.InternationalizedClientInfo;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.scopes.ScopeInfo;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenIssuer;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenRefreshRequest;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenResponse;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.IRefreshTokenAccessor;
import com.sap.cloud.security.oauth2.as.commons.token.refreshtoken.RefreshTokenInfo;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.issuers.TokenIssuingService;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenIssuingService
implements TokenIssuingService {
    private static final Logger logger = LoggerFactory.getLogger(RefreshTokenIssuingService.class);
    private AccessTokenIssuer tokenIssuer;
    private IRefreshTokenAccessor refreshTokenAccessor;
    private IClientAccessor clientAccessor;
    private ClientIdProvider clientIdProvider;

    public RefreshTokenIssuingService(AccessorFactory accessorFactory, ClientIdProvider clientIdProvider) {
        this.tokenIssuer = this.createTokenIssuer(accessorFactory);
        this.refreshTokenAccessor = accessorFactory.getRefreshTokenAccessor();
        this.clientAccessor = accessorFactory.getClientAccessor();
        this.clientIdProvider = clientIdProvider;
    }

    AccessTokenIssuer createTokenIssuer(AccessorFactory accessorFactory) {
        return new AccessTokenIssuer(accessorFactory.getAccessTokenAccessor(), accessorFactory.getRefreshTokenAccessor());
    }

    @Override
    public AccessTokenResponse issueToken(RequestAttributes attributes) {
        logger.debug("Issuing access token for refresh token flow.");
        RefreshTokenInfo refreshToken = this.retrieveRefreshToken(attributes.getRefreshToken());
        InternationalizedClientInfo client = this.retreiveClient(this.clientIdProvider.getClientIdFrom(attributes));
        Set<ScopeInfo> scopes = this.resolveScopes(attributes, refreshToken);
        try {
            return this.tokenIssuer.issueToken(new AccessTokenRefreshRequest(scopes, client, refreshToken));
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to issue token.", exception);
        }
    }

    private Set<ScopeInfo> resolveScopes(RequestAttributes attributes, RefreshTokenInfo refreshToken) {
        String[] requestedScopes = attributes.getScopesAsArray();
        if (requestedScopes.length == 0) {
            return refreshToken.getScopes();
        }
        if (requestedScopes.length == 1 && "".equals(requestedScopes[0].trim())) {
            return refreshToken.getScopes();
        }
        return refreshToken.getAllScopesMatching(requestedScopes);
    }

    RefreshTokenInfo retrieveRefreshToken(String token) {
        try {
            return this.refreshTokenAccessor.getToken(token);
        }
        catch (Exception exception) {
            throw new UnexpectedFlowException("Failed to retrieve refresh token.", exception);
        }
    }

    InternationalizedClientInfo retreiveClient(String clientId) {
        try {
            return this.clientAccessor.getInternationalizedClientByID(clientId, null);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive client by id.", exception);
        }
    }
}

