/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.issuers;

import com.sap.cloud.security.oauth2.as.commons.accessor.AccessorFactory;
import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.code.userinfo.UserInfoAdapter;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenIssuer;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenResponse;
import com.sap.cloud.security.oauth2.as.commons.token.accesstoken.AccessTokenSAMLBearerRequest;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.issuers.TokenIssuingService;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import com.sap.cloud.security.oauth2.flow.service.SAMLService;
import com.sap.security.saml2.commons.SAML2Principal;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLBearerTokenIssuingService
implements TokenIssuingService {
    private static final Logger logger = LoggerFactory.getLogger(SAMLBearerTokenIssuingService.class);
    private SAMLService samlService;
    private AccessTokenIssuer tokenIssuer;
    private IClientAccessor clientAccessor;
    private ClientIdProvider clientIdProvider;

    public SAMLBearerTokenIssuingService(AccessorFactory accessorFactory, SAMLService samlService, ClientIdProvider clientIdProvider) {
        this.tokenIssuer = new AccessTokenIssuer(accessorFactory.getAccessTokenAccessor(), accessorFactory.getRefreshTokenAccessor());
        this.clientAccessor = accessorFactory.getClientAccessor();
        this.samlService = samlService;
        this.clientIdProvider = clientIdProvider;
    }

    @Override
    public AccessTokenResponse issueToken(RequestAttributes attributes) {
        logger.debug("Issuing access token for SAML bearer flow.");
        BasicClientInfo client = this.retreiveClient(this.clientIdProvider.getClientIdFrom(attributes));
        SAML2Principal principal = this.samlService.resolveUserPrincipal(attributes.getAssertion());
        try {
            return this.tokenIssuer.issueToken(new AccessTokenSAMLBearerRequest(Collections.emptySet(), client, new UserInfoAdapter(principal), principal.getName()));
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to issue token.", exception);
        }
    }

    private BasicClientInfo retreiveClient(String clientId) {
        try {
            return this.clientAccessor.getBasicClientById(clientId);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive client by given id.", exception);
        }
    }
}

