/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.code;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.code.AuthzCodeInfo;
import com.sap.cloud.security.oauth2.as.commons.code.IAuthzCodeAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationCodeExistence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationCodeExistence.class);
    private IAuthzCodeAccessor accessor;

    public AuthorizationCodeExistence(IAuthzCodeAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether the provided authorization code exist.");
        String authorizationCode = attributes.getAuthorizationCode();
        AuthzCodeInfo authzCodeInfo = this.retrieveAuthorizationCode(authorizationCode);
        if (authzCodeInfo == null) {
            throw new UnsatisfiedFlowException("Authorization code is not valid.", ErrorCode.invalid_grant);
        }
    }

    private AuthzCodeInfo retrieveAuthorizationCode(String authorizationCode) {
        try {
            return this.accessor.getAuthzCodeInfo(authorizationCode);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive authorization code by given identifier", exception);
        }
    }

    public String toString() {
        return "Existing authorization code";
    }
}

