/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.code;

import com.sap.cloud.security.oauth2.as.commons.code.AuthzCodeInfo;
import com.sap.cloud.security.oauth2.as.commons.code.IAuthzCodeAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnauthorizedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationCodeOwnerMatch
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationCodeOwnerMatch.class);
    private IAuthzCodeAccessor authzCodeAccessor;
    private ClientIdProvider clientIdProvider;

    public AuthorizationCodeOwnerMatch(IAuthzCodeAccessor authzCodeAccessor, ClientIdProvider clientIdProvider) {
        this.authzCodeAccessor = authzCodeAccessor;
        this.clientIdProvider = clientIdProvider;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether the authorization code is issued for the given client.");
        String clientId = this.clientIdProvider.getClientIdFrom(attributes);
        String authorizationCode = attributes.getAuthorizationCode();
        AuthzCodeInfo authzCodeInfo = this.retrieveAuthorizationCode(authorizationCode);
        if (!clientId.equals(authzCodeInfo.getClientId())) {
            throw new UnauthorizedFlowException("Authorization code is issued for different client than provided.");
        }
    }

    private AuthzCodeInfo retrieveAuthorizationCode(String authorizationCode) {
        try {
            return this.authzCodeAccessor.getAuthzCodeInfo(authorizationCode);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive authorization code by given identifier", exception);
        }
    }
}

