/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.code;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationCodePresence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationCodePresence.class);

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether authorization code is in the request attributes.");
        String[] values = attributes.getAuthorizationCodeParameters();
        if (values == null || values.length == 0) {
            throw new UnsatisfiedFlowException("'code' parameter is required field.", ErrorCode.invalid_request);
        }
        if (values.length > 1) {
            throw new UnsatisfiedFlowException("'code' parameter must be included only once.", ErrorCode.invalid_request);
        }
        if ("".equals(values[0])) {
            throw new UnsatisfiedFlowException("'code' parameter has to be non empty string.", ErrorCode.invalid_request);
        }
    }

    public String toString() {
        return "Presence of authorization code";
    }
}

