/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.code;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.code.AuthzCodeInfo;
import com.sap.cloud.security.oauth2.as.commons.code.IAuthzCodeAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.as.commons.utils.DateTimeUtils;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationCodeValidity
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationCodeValidity.class);
    private IAuthzCodeAccessor authzCodeAccessor;
    private IClientAccessor clientAccessor;
    private ClientIdProvider clientIdProvider;

    public AuthorizationCodeValidity(IAuthzCodeAccessor authzCodeAcessor, IClientAccessor clientAccessor, ClientIdProvider clientIdProvider) {
        this.authzCodeAccessor = authzCodeAcessor;
        this.clientAccessor = clientAccessor;
        this.clientIdProvider = clientIdProvider;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether the provided authorization code is not expired.");
        String authorizationCode = attributes.getAuthorizationCode();
        AuthzCodeInfo authzCodeInfo = this.retrieveAuthorizationCode(authorizationCode);
        BasicClientInfo clientInfo = this.retreiveClient(this.clientIdProvider.getClientIdFrom(attributes));
        long issuedAt = authzCodeInfo.getIssuedAt();
        int expiersInSec = clientInfo.getAuthzCodeExpiresIn();
        if (DateTimeUtils.isDateExpired(issuedAt, expiersInSec)) {
            throw new UnsatisfiedFlowException("Authorization code is expired.", ErrorCode.invalid_grant);
        }
    }

    private AuthzCodeInfo retrieveAuthorizationCode(String authorizationCode) {
        try {
            return this.authzCodeAccessor.getAuthzCodeInfo(authorizationCode);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive authorization code by given identifier", exception);
        }
    }

    private BasicClientInfo retreiveClient(String clientId) {
        try {
            return this.clientAccessor.getBasicClientById(clientId);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive client by given id.", exception);
        }
    }

    public String toString() {
        return "Valid authorization code";
    }
}

