/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.code;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.code.AuthzCodeInfo;
import com.sap.cloud.security.oauth2.as.commons.code.IAuthzCodeAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectURIValidity
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(RedirectURIValidity.class);
    private IAuthzCodeAccessor accessor;

    public RedirectURIValidity(IAuthzCodeAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether redirect URI is valid.");
        String authzCodeRedirectURI = this.fetchAuthorizationCodeRedirectURI(attributes.getAuthorizationCode());
        String[] redirectURIs = attributes.getRedirectURIParameters();
        if (this.redirectURIIsMissing(redirectURIs) && authzCodeRedirectURI == null) {
            logger.debug("Redirect URI is not presented in the request, but authorization code was issued without redirect URI also, so the request would be allowed.");
            return;
        }
        if (this.redirectURIIsMissing(redirectURIs) && authzCodeRedirectURI != null) {
            throw new UnsatisfiedFlowException("Redirect URI is required field as it was included in the initial authorization request.", ErrorCode.invalid_request);
        }
        if (redirectURIs.length > 1) {
            throw new UnsatisfiedFlowException("Parameter redirect_uri must be included only once.", ErrorCode.invalid_request);
        }
        if (authzCodeRedirectURI == null) {
            throw new UnsatisfiedFlowException("Redirect URI parameter is not needed in the request as it wasn't passed in the initial authorization request as well.", ErrorCode.invalid_request);
        }
        if (!authzCodeRedirectURI.equals(redirectURIs[0])) {
            throw new UnsatisfiedFlowException("Redirect URI used in the request doesn't match the one provided with the authorization code.", ErrorCode.invalid_grant);
        }
    }

    private boolean redirectURIIsMissing(String[] redirectValues) {
        return redirectValues == null || redirectValues.length == 0;
    }

    String fetchAuthorizationCodeRedirectURI(String authorizationCode) {
        AuthzCodeInfo authzCodeInfo;
        block3: {
            try {
                authzCodeInfo = this.accessor.getAuthzCodeInfo(authorizationCode);
                if (authzCodeInfo != null) break block3;
                return null;
            }
            catch (InternalErrorException exception) {
                throw new UnexpectedFlowException("Failed to fetch authorization code", exception);
            }
        }
        return authzCodeInfo.getRedirectUri();
    }

    public String toString() {
        return "Valid redirect URI";
    }
}

