/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.common;

import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnauthorizedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.service.AuthorizationHeaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHeaderPresence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationHeaderPresence.class);
    private AuthorizationHeaderService service;

    public AuthorizationHeaderPresence(AuthorizationHeaderService service) {
        this.service = service;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether authorization header is presented in the request.");
        String authorizationHeader = attributes.getAuthorizationHeader();
        if (authorizationHeader == null) {
            throw new UnauthorizedFlowException("Client credentials must be provided.");
        }
        String[] clientIdAndSecret = this.service.extractUsernameAndPasswordFrom(authorizationHeader);
        if (this.clientIdAndSecretNotValid(clientIdAndSecret)) {
            throw new UnauthorizedFlowException("Wrong credentials format.");
        }
    }

    private boolean clientIdAndSecretNotValid(String[] clientIdAndSecret) {
        return clientIdAndSecret == null || clientIdAndSecret.length != 2;
    }

    public String toString() {
        return "Presence of authorization header";
    }
}

