/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.common;

import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnauthorizedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.service.ClientIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientExistence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(ClientExistence.class);
    private ClientIdProvider clientIdProvider;
    private IClientAccessor accessor;

    public ClientExistence(IClientAccessor accessor, ClientIdProvider clientIdProvider) {
        this.accessor = accessor;
        this.clientIdProvider = clientIdProvider;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether client exists.");
        String clientId = this.clientIdProvider.getClientIdFrom(attributes);
        BasicClientInfo client = this.retreiveClient(clientId);
        if (client == null) {
            throw new UnauthorizedFlowException("Cannot find requested client id: " + clientId);
        }
    }

    private BasicClientInfo retreiveClient(String clientId) {
        try {
            return this.accessor.getBasicClientById(clientId);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive client by given id.", exception);
        }
    }

    public String toString() {
        return "Existing client";
    }
}

