/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.common;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientIdPresence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(ClientIdPresence.class);

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether client ID is presented in the request.");
        String[] clientIds = attributes.getClientIdParameters();
        if (clientIds == null || clientIds.length == 0) {
            throw new UnsatisfiedFlowException("There are no client credentials in the request so client_id parameter is required.", ErrorCode.invalid_request);
        }
        if (clientIds.length > 1) {
            throw new UnsatisfiedFlowException("Parameter client_id must be included only once.", ErrorCode.invalid_request);
        }
        if ("".equals(clientIds[0])) {
            throw new UnsatisfiedFlowException("Parameter client_id has to be non empty string.", ErrorCode.invalid_request);
        }
    }

    public String toString() {
        return "Presence of client ID in the request";
    }
}

