/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.common;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformScopesExistence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(PlatformScopesExistence.class);
    private IClientAccessor accessor;

    public PlatformScopesExistence(IClientAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether scopes exist.");
        String[] requestedScopes = attributes.getScopesAsArray();
        if (requestedScopes != null && requestedScopes.length == 1 && "".equals(requestedScopes[0].trim())) {
            logger.error("Somebody has send scope parameter with empty value, which is not allowed according to OAuth 2.0 specification.");
            return;
        }
        String clientId = attributes.getClientIdFromAuthorizationHeader();
        BasicClientInfo client = this.retreiveClient(clientId);
        if (!client.containsAllScopes(requestedScopes)) {
            throw new UnsatisfiedFlowException("Scopes exceed the scope registered for the client.", ErrorCode.invalid_scope);
        }
    }

    private BasicClientInfo retreiveClient(String clientId) {
        try {
            return this.accessor.getBasicClientById(clientId);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retreive client by given id.", exception);
        }
    }

    public String toString() {
        return "Existing scopes";
    }
}

