/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.common;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.as.commons.client.BasicClientInfo;
import com.sap.cloud.security.oauth2.as.commons.client.ClientType;
import com.sap.cloud.security.oauth2.as.commons.client.IClientAccessor;
import com.sap.cloud.security.oauth2.as.commons.exception.InternalErrorException;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnexpectedFlowException;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicClient
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(PublicClient.class);
    private IClientAccessor accessor;

    public PublicClient(IClientAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether client is public.");
        String clientId = attributes.getClientId();
        BasicClientInfo client = this.retreiveClient(clientId);
        if (this.clientIsConfidential(client)) {
            throw new UnsatisfiedFlowException("Provided client is confidential.", ErrorCode.invalid_client);
        }
    }

    private BasicClientInfo retreiveClient(String clientId) {
        try {
            return this.accessor.getBasicClientById(clientId);
        }
        catch (InternalErrorException exception) {
            throw new UnexpectedFlowException("Failed to retrieve client by given identifier.", exception);
        }
    }

    private boolean clientIsConfidential(BasicClientInfo client) {
        return client.getClientType() == ClientType.CONFIDENTIAL;
    }

    public String toString() {
        return "Public client";
    }
}

