/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.common;

import com.sap.cloud.security.oauth2.as.commons.ErrorCode;
import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.exceptions.UnsatisfiedFlowException;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopesParamPresence
implements FlowRequirement {
    private static final Logger logger = LoggerFactory.getLogger(ScopesParamPresence.class);

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        logger.debug("Checking whether scopes are presented in the request.");
        String[] scopesParam = attributes.getScopeParameters();
        if (scopesParam != null && scopesParam.length > 1) {
            throw new UnsatisfiedFlowException("Parameter scope must be included only once.", ErrorCode.invalid_request);
        }
    }

    public String toString() {
        return "Presence of scopes";
    }
}

