/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.flow.requirements.common;

import com.sap.cloud.security.oauth2.flow.attributes.RequestAttributes;
import com.sap.cloud.security.oauth2.flow.requirements.FlowRequirement;
import com.sap.cloud.security.oauth2.flow.requirements.condition.RequirementCondition;

public class TernaryConditionalRequirement
implements FlowRequirement {
    private RequirementCondition condition;
    private FlowRequirement conditionRequirement;
    private FlowRequirement nonConditionRequirement;

    public TernaryConditionalRequirement(RequirementCondition condition, FlowRequirement conditionRequirement, FlowRequirement nonConditionRequirement) {
        this.condition = condition;
        this.conditionRequirement = conditionRequirement;
        this.nonConditionRequirement = nonConditionRequirement;
    }

    @Override
    public void fulfilledBy(RequestAttributes attributes) {
        if (this.condition.isFulfilled(attributes)) {
            this.conditionRequirement.fulfilledBy(attributes);
        } else {
            this.nonConditionRequirement.fulfilledBy(attributes);
        }
    }

    public String toString() {
        return "Ternary requirement, with condition: [" + this.condition + "] and requirements: [[" + this.conditionRequirement + "] and [" + this.nonConditionRequirement + "]]";
    }
}

